/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.msdldt.ui.editor.MSDLWordFinder;

public class MSDLDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private ICharacterPairMatcher fPairMatcher;

    public MSDLDoubleClickStrategy(ICharacterPairMatcher pairMatcher) {
        this.fPairMatcher = pairMatcher;
    }

    public void doubleClicked(ITextViewer textViewer) {
        block25: {
            try {
                Position[] positions;
                int offset = textViewer.getSelectedRange().x;
                if (offset < 0) {
                    return;
                }
                if (this.fPairMatcher == null) {
                    return;
                }
                IDocument document = textViewer.getDocument();
                IRegion region = this.fPairMatcher.match(document, offset);
                if (region != null && region.getLength() >= 2) {
                    textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
                    break block25;
                }
                region = MSDLWordFinder.getDefault().getWordAtOffset(document, offset, true);
                if (region.getLength() == 0 && region.getOffset() == 0) {
                    region = new Region(offset, 0);
                }
                if (document.containsPositionCategory("__dvt_folding_position") && (positions = document.getPositions("__dvt_folding_position")) != null) {
                    int nested = 0;
                    int i = 0;
                    block2: while (i < positions.length) {
                        Position position = positions[i];
                        if (((DVTFoldingPosition)position).isIncludedBy(region.getOffset(), region.getLength()) && (i + 1 >= positions.length || !((DVTFoldingPosition)positions[i + 1]).isIncludedBy(region.getOffset(), region.getLength()) || ((DVTFoldingPosition)positions[i + 1]).length == 0)) {
                            if (((DVTFoldingPosition)position).getSubType() == DVTFoldingPosition.SubType.START) {
                                DVTFoldingPosition.Type lookFor = ((DVTFoldingPosition)position).getType();
                                ++nested;
                                int j = i + 1;
                                while (j < positions.length) {
                                    position = positions[j];
                                    if (((DVTFoldingPosition)position).getType() == lookFor) {
                                        if (((DVTFoldingPosition)position).getSubType() == DVTFoldingPosition.SubType.END) {
                                            if (--nested == 0) {
                                                region = new Region(region.getOffset(), position.getOffset() - region.getOffset() + 1);
                                                break block2;
                                            }
                                        } else if (((DVTFoldingPosition)position).getSubType() == DVTFoldingPosition.SubType.START) {
                                            ++nested;
                                        }
                                    }
                                    ++j;
                                }
                                break;
                            }
                            if (((DVTFoldingPosition)position).getSubType() == DVTFoldingPosition.SubType.END) {
                                DVTFoldingPosition.Type lookFor = ((DVTFoldingPosition)position).getType();
                                --nested;
                                int j = i - 1;
                                while (j >= 0) {
                                    position = positions[j];
                                    if (((DVTFoldingPosition)position).getType() == lookFor) {
                                        if (((DVTFoldingPosition)position).getSubType() == DVTFoldingPosition.SubType.END) {
                                            --nested;
                                        } else if (((DVTFoldingPosition)position).getSubType() == DVTFoldingPosition.SubType.START && ++nested == 0 && ((DVTFoldingPosition)position).getMeta() != DVTFoldingPosition.ELSEIF) {
                                            region = new Region(position.getOffset(), region.getOffset() - position.getOffset() + region.getLength());
                                            break block2;
                                        }
                                    }
                                    --j;
                                }
                                break;
                            }
                        }
                        ++i;
                    }
                }
                if (region.getLength() != 0) {
                    textViewer.setSelectedRange(region.getOffset(), region.getLength());
                } else {
                    char c = TextUtils.getChar((IDocument)document, (int)offset);
                    if (Character.isWhitespace(c)) {
                        region = DVTDocumentCommon.getWhitespaceBlockAtOffset((IDocument)document, (int)offset);
                        textViewer.setSelectedRange(region.getOffset(), region.getLength());
                    }
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

