/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.msdldt.model.IMSDLModel;
import ro.amiq.msdldt.model.IMSDLModule;
import ro.amiq.msdldt.model.MSDLModelManager;
import ro.amiq.msdldt.ui.editor.MSDLSourceViewerConfiguration;
import ro.amiq.msdldt.ui.editor.MSDLWordFinder;

public abstract class MSDLEditorCommon
extends DVTEditor {
    public static final String ID = "ro.amiq.msdldt.ui.editor.MSDLEditor";

    public void scheduleReparse(IDocument document, IFile file) {
        IMSDLModel model = MSDLModelManager.getInstance().getMSDLModel();
        if (model == null) {
            return;
        }
        IMSDLModule module = model.getOrCreateMSDLFile(file);
        if (module == null) {
            return;
        }
        boolean shouldIncrementalBuild = DVTFileUtils.getInstance().shouldIncrementalBuild(this.getDocument(), null, this.getProject());
        if (shouldIncrementalBuild) {
            int buildAutoTime = DVTPlugin.getDefault().getPreferenceStore().getInt("ro.amiq.dvt.TRIGGER_AUTOBUILD_VALUE");
            module.scheduleReparse(false, false, (long)buildAutoTime * 1000L, document, false);
        }
    }

    public DVTWordFinder getWordFinder() {
        return MSDLWordFinder.getDefault();
    }

    protected boolean c() {
        return DVTPlugin.getDefault().collect().c(this.getProject(), "F73646C");
    }

    public IRfNamedElementAndScope getCursorElement() {
        return this.getCursorElementNonUi(this.getCursor());
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.MSDL;
    }

    public DVTSourceViewerConfiguration makeSourceViewerConfiguration() {
        return new MSDLSourceViewerConfiguration(null);
    }

    public String getEditorID() {
        return ID;
    }

    public String getCodePartition() {
        return "__msdl_partitioning";
    }
}

