/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.IHighlightListener;
import ro.amiq.msdldt.ui.editor.MSDLStyle;
import ro.amiq.msdldt.ui.editor.rules.MSDLEventDetector;
import ro.amiq.msdldt.ui.editor.rules.MSDLExpansionRule;
import ro.amiq.msdldt.ui.editor.rules.MSDLFoldingZoneMarker;
import ro.amiq.msdldt.ui.editor.rules.MSDLKeyWordRule;
import ro.amiq.msdldt.ui.editor.rules.MSDLNumericRule;
import ro.amiq.msdldt.ui.editor.rules.MSDLWhitespaceDetector;

public class MSDLExpansionScanner
extends DVTBaseScanner {
    private MSDLKeyWordRule fMSDLKeyWordRule;

    public MSDLExpansionScanner(MSDLStyle style, int nofLinesFolding) {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MSDLExpansionRule(style.getToken("highlight.string")));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new MSDLWhitespaceDetector()));
        rules.add(new WordRule((IWordDetector)new MSDLEventDetector(), style.getToken("highlight.event")));
        this.fMSDLKeyWordRule = new MSDLKeyWordRule(style);
        DVTHlUtils.addListener((IHighlightListener)this.fMSDLKeyWordRule);
        rules.add(this.fMSDLKeyWordRule);
        rules.add(new MSDLFoldingZoneMarker(nofLinesFolding));
        rules.add(new MSDLNumericRule(style.getToken("highlight.number")));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public void setNofLinesFolding(int nofLines) {
        if (this.fRules != null) {
            IRule[] iRuleArray = this.fRules;
            int n = this.fRules.length;
            int n2 = 0;
            while (n2 < n) {
                IRule rule = iRuleArray[n2];
                if (rule instanceof MSDLFoldingZoneMarker) {
                    ((MSDLFoldingZoneMarker)rule).setNofLinesFolding(nofLines);
                }
                ++n2;
            }
        }
    }

    public void dispose() {
        DVTHlUtils.removeListener((IHighlightListener)this.fMSDLKeyWordRule);
        super.dispose();
    }
}

