/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class MSDLPartitionScanner
extends BufferedRuleBasedScanner
implements IPartitionTokenScanner {
    public static final int ML_COMMENT = 0;
    public static final int SL_COMMENT = 1;
    public static final int LITERAL = 2;
    public static final int EXPANSION_LITERAL = 4;
    public static final int CODE = 5;
    public static final int ESCAPED_ID = 6;
    private int fState = 5;
    private int fTokenLength = 0;
    private boolean fBackslash = false;
    private int fChar = 97;
    private boolean fLimitPartitionLength;
    private int fNested = 0;

    public MSDLPartitionScanner() {
        this.fLimitPartitionLength = true;
    }

    public MSDLPartitionScanner(boolean limitPartitionLength) {
        this.fLimitPartitionLength = limitPartitionLength;
    }

    public IToken nextToken() {
        this.fBackslash = false;
        IToken result = this.internalNextToken();
        return result;
    }

    public int read() {
        ++this.fTokenLength;
        return super.read();
    }

    public void unread() {
        --this.fTokenLength;
        super.unread();
    }

    private final IToken internalNextToken() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = 0;
        int nested = 0;
        while ((this.fChar = this.read()) != -1) {
            boolean forceBackslash = false;
            switch (this.fState) {
                case 5: {
                    int ch;
                    if (this.fLimitPartitionLength && this.fTokenLength > 2000 && (this.fChar == 13 || this.fChar == 10)) {
                        this.fBackslash = false;
                        return new Token((Object)"__dftl_partition_content_type");
                    }
                    if (this.fChar == 35) {
                        this.fState = 1;
                        if (this.fTokenLength <= 1) break;
                        this.unread();
                        return new Token((Object)"__dftl_partition_content_type");
                    }
                    if (this.fChar == 47) {
                        ch = this.read();
                        this.unread();
                        if (ch != 42) break;
                        this.unread();
                        this.fState = 0;
                        if (this.fTokenLength <= 1) break;
                        return new Token((Object)"__dftl_partition_content_type");
                    }
                    if (this.fChar != 34) break;
                    this.fState = 2;
                    if (this.fTokenLength <= 1) break;
                    this.unread();
                    return new Token((Object)"__dftl_partition_content_type");
                }
                case 2: {
                    if (this.fChar == 34 && this.fTokenLength > 1) {
                        this.fState = 5;
                        return new Token((Object)"__msdl_literal");
                    }
                    if (this.fChar != 36) break;
                    int ch = this.read();
                    if (ch == 40) {
                        this.fState = 4;
                        return new Token((Object)"__msdl_literal");
                    }
                    this.unread();
                    break;
                }
                case 4: {
                    if (this.fChar == 40) {
                        ++this.fNested;
                        break;
                    }
                    if (this.fNested == 0 && this.fChar == 41) {
                        this.unread();
                        this.fState = 2;
                        return new Token((Object)"__msdl_literal_interpol");
                    }
                    if (this.fChar != 41) break;
                    --this.fNested;
                    break;
                }
                case 0: {
                    int ch;
                    if (this.fChar == 47) {
                        ch = this.read();
                        if (ch != 42) break;
                        ++nested;
                        break;
                    }
                    if (this.fChar != 42 || (ch = this.read()) != 47) break;
                    if (nested > 0) {
                        --nested;
                    }
                    if (nested != 0) break;
                    this.fState = 5;
                    return new Token((Object)"__msdl_ml_comment");
                }
                case 1: {
                    if (this.fChar != 13 && this.fChar != 10) break;
                    if (this.fChar == 13 && this.read() != 10) {
                        this.unread();
                    }
                    this.fState = 5;
                    return new Token((Object)"__msdl_sl_comment");
                }
            }
            boolean bl = this.fBackslash = !this.fBackslash && this.fChar == 92 ? true : forceBackslash;
        }
        if (this.fTokenLength > 1) {
            --this.fTokenLength;
            switch (this.fState) {
                case 5: 
                case 6: {
                    return new Token((Object)"__dftl_partition_content_type");
                }
                case 2: {
                    return new Token((Object)"__msdl_literal");
                }
                case 4: {
                    return new Token((Object)"__msdl_literal_interpol");
                }
                case 0: {
                    return new Token((Object)"__msdl_ml_comment");
                }
            }
            return new Token((Object)"__msdl_sl_comment");
        }
        return Token.EOF;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        super.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
        this.fNested = 0;
        this.fState = contentType == null ? 5 : (contentType.equals("__dftl_partition_content_type") ? 5 : (contentType.equals("__msdl_literal") ? 2 : (contentType.equals("__msdl_literal_interpol") ? 4 : (contentType.equals("__msdl_sl_comment") ? 1 : 0))));
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
        this.fNested = 0;
        this.fState = 5;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }
}

