/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.msdldt.ui.preferences.PrefConst;

public class MSDLWordFinder
extends DVTWordFinder {
    private static MSDLWordFinder fMSDLWordFinder;

    public static MSDLWordFinder getDefault() {
        if (fMSDLWordFinder == null) {
            fMSDLWordFinder = new MSDLWordFinder();
        }
        return fMSDLWordFinder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isKeyWord(IDocument document, IRegion region) {
        try {
            String word = document.get(region.getOffset(), region.getLength());
            String[] words = PrefConst.getMSDLKeywords();
            int i = 0;
            while (i < words.length) {
                if (words[i].equals(word)) {
                    return true;
                }
                ++i;
            }
            words = PrefConst.getMSDLTypes();
            i = 0;
            while (i < words.length) {
                if (words[i].equals(word)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IRegion getWordAtOffset(IDocument document, int offset) {
        return this.getWordAtOffset(document, offset, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRegion getExpressionAtOffset(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            int pos = offset;
            if (pos < 0 || document.getLength() == 0) {
                return new Region(0, 0);
            }
            int ch = this.getChar(document, pos - 1);
            if (!Character.isJavaIdentifierPart((char)ch)) {
                ch = this.getChar(document, pos);
                if (!Character.isJavaIdentifierPart((char)ch)) {
                    return new Region(0, 0);
                }
                ++pos;
            }
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, pos - 1), false);
            EXPRESSION_STATE state = EXPRESSION_STATE.CODE;
            int nested = 0;
            block11: while (pos > 0) {
                ch = scanner.read();
                switch (state) {
                    case CODE: {
                        if ((char)ch == '\"') {
                            state = EXPRESSION_STATE.LITERAL_START;
                            break;
                        }
                        if ((char)ch == '.') {
                            state = EXPRESSION_STATE.DOT;
                            break;
                        }
                        if (((char)ch == '{' || (char)ch == '[' || (char)ch == '(') && nested == 0) break block11;
                        if ((char)ch == '(' || (char)ch == '{' || (char)ch == '[') {
                            --nested;
                            break;
                        }
                        if ((char)ch == ')' || (char)ch == '}' || (char)ch == ']') {
                            ++nested;
                            break;
                        }
                        if (Character.isWhitespace((char)ch)) {
                            state = EXPRESSION_STATE.WS_CODE;
                            break;
                        }
                        if (Character.isJavaIdentifierPart((char)ch) || (char)ch == '.' || (char)ch == '$' || nested != 0) break;
                        break block11;
                    }
                    case LITERAL_START: {
                        if ((char)ch == '\\') {
                            state = EXPRESSION_STATE.CODE;
                            break;
                        }
                        if ((char)ch == '\"') {
                            state = EXPRESSION_STATE.LITERAL_END;
                            break;
                        }
                        state = EXPRESSION_STATE.LITERAL;
                        break;
                    }
                    case LITERAL: {
                        if ((char)ch != '\"') break;
                        state = EXPRESSION_STATE.LITERAL_END;
                        break;
                    }
                    case LITERAL_END: {
                        if ((char)ch == '\\') {
                            state = EXPRESSION_STATE.LITERAL;
                            break;
                        }
                        if ((char)ch == '\"') {
                            state = EXPRESSION_STATE.LITERAL_START;
                            break;
                        }
                        state = EXPRESSION_STATE.CODE;
                        break;
                    }
                    case DOT: {
                        if (Character.isWhitespace((char)ch)) {
                            state = EXPRESSION_STATE.WS_DOT;
                        } else if (((char)ch == '{' || (char)ch == '[' || (char)ch == '(') && nested == 0) break block11;
                        state = EXPRESSION_STATE.CODE;
                        break;
                    }
                    case WS_DOT: {
                        if (((char)ch == '{' || (char)ch == '[' || (char)ch == '(') && nested == 0) break block11;
                        state = EXPRESSION_STATE.CODE;
                        break;
                    }
                    case WS_CODE: {
                        if ((char)ch == '.') {
                            state = EXPRESSION_STATE.DOT;
                        } else if (Character.isWhitespace((char)ch)) {
                            state = EXPRESSION_STATE.WS_CODE;
                        } else if (nested == 0) break block11;
                        state = EXPRESSION_STATE.CODE;
                    }
                }
                --pos;
            }
            start = pos;
            pos = offset;
            scanner = new DVTCharacterScanner(20, document, pos, true);
            while (ch != -1 && (Character.isJavaIdentifierPart((char)(ch = scanner.read())) || (char)ch == '$')) {
                ++pos;
            }
            end = pos;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            return new Region(start, end - start);
        }
        return new Region(0, 0);
    }

    public IRegion getWordAtOffset(IDocument document, int offset, boolean enableNumerics) {
        int start = -1;
        int end = -1;
        int pos = offset;
        if (pos < 0 || document.getLength() == 0) {
            return new Region(0, 0);
        }
        char ch = this.getChar(document, pos - 1);
        if (!Character.isJavaIdentifierPart(ch) && ch != '~') {
            ch = this.getChar(document, pos);
            if (!Character.isJavaIdentifierPart(ch) && ch != '~') {
                return new Region(0, 0);
            }
            ++pos;
        }
        DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, pos - 1), false);
        while (pos >= 0) {
            ch = (char)scanner.read();
            scanner.read();
            scanner.unread();
            if (!Character.isJavaIdentifierPart(ch) && ch != '~') break;
            --pos;
        }
        ch = this.getChar(document, pos);
        if (!Character.isJavaIdentifierStart(ch) && ch != '~' && !enableNumerics) {
            return new Region(0, 0);
        }
        start = pos;
        pos = offset;
        scanner = new DVTCharacterScanner(20, document, pos, true);
        while (ch != '\uffff') {
            ch = (char)scanner.read();
            if (!Character.isJavaIdentifierPart(ch) && ch != '~') break;
            ++pos;
        }
        end = pos;
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            return new Region(start, end - start);
        }
        return new Region(0, 0);
    }

    private static enum EXPRESSION_STATE {
        SL_COMMENT,
        LITERAL,
        LITERAL_START,
        LITERAL_END,
        CODE,
        DOT,
        WS_CODE,
        WS_DOT;

    }
}

