/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.actions.IReferencesAction;
import ro.amiq.dvt.ui.search.BaseReferencesInWorkspaceAction;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.util.RfUtils;
import ro.amiq.msdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.msdldt.ui.search.ReferenceSearchPageInput;
import ro.amiq.msdldt.ui.search.SearchQueryProvider;

public class ReferencesInWorkspaceAction
extends BaseReferencesInWorkspaceAction
implements IReferencesAction {
    public ReferencesInWorkspaceAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    protected void informationDialog() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Limited Operation", null, "The operation is unavailable on the current selection (the scope could not be determined). Please select another MSDL Language element name or the same element from another location.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return;
        }
        int offset = ((DVTEditor)textEditor).getCursor();
        this.searchReferences(textEditor, document, offset, false);
    }

    public ISearchQuery searchReferences(ITextEditor textEditor, IDocument document, int offset, boolean includeDeclarations) {
        IRfNamedElement element;
        RfProject rfProject;
        block7: {
            block6: {
                IProject project;
                block5: {
                    try {
                        project = this.getProject(textEditor);
                        if (project != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.MSDL_FAMILY_REPARSE);
                rfProject = RfManager.getInstance().getRfProject(project);
                if (rfProject != null) break block6;
                return null;
            }
            element = null;
            RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(textEditor, document, offset);
            if (elementAndScope != null && (element = elementAndScope.getIRfNamedElement()) != null) break block7;
            this.informationDialog();
            return null;
        }
        FileTextSearchScope searchScope = this.getSearchScope(ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject), textEditor);
        ReferenceSearchPageInput input = new ReferenceSearchPageInput(element, false, false, true, searchScope);
        ISearchQuery result = ReferencesInWorkspaceAction.searchReferencesHelper(input, includeDeclarations);
        return result;
    }

    public static ISearchQuery searchReferencesHelper(ReferenceSearchPageInput input, boolean includeDeclarations) {
        try {
            ISearchQuery query = new SearchQueryProvider(1, 4, includeDeclarations, true).createQuery((TextSearchQueryProvider.TextSearchInput)input);
            if (query != null) {
                NewSearchUI.runQueryInBackground((ISearchQuery)query);
            }
            return query;
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
    }

    protected FileTextSearchScope getSearchScope(String[] fileExtensions, ITextEditor textEditor) {
        return FileTextSearchScope.newWorkspaceScope((String[])fileExtensions, (boolean)false);
    }

    protected IProject getProject(ITextEditor textEditor) {
        IFile file = this.getFile(textEditor);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    protected IFile getFile(ITextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        return file;
    }
}

