/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.contentassist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.templates.TemplateEditorUI;
import ro.amiq.msdldt.ui.editor.MSDLEditor;
import ro.amiq.msdldt.ui.editor.MSDLSourceViewerConfiguration;
import ro.amiq.msdldt.ui.editor.contentassist.MSDLContentAssistProcessorManager;

public class MSDLTemplateContentAssistProcessor
extends TemplateCompletionProcessor {
    private static final String MSDL_CODE_TEMPLATES = "pss_code_templates.xml";
    private MSDLContentAssistProcessorManager fAssistant;
    private MSDLEditor fEditor;
    private boolean fCA = false;
    private int fOffset;
    private static final Comparator<ICompletionProposal> fgProposalComparator = new ProposalComparator();

    public MSDLTemplateContentAssistProcessor(MSDLEditor editor, MSDLContentAssistProcessorManager assistant) {
        this.fAssistant = assistant;
        this.fEditor = editor;
    }

    protected int getRelevance(Template template, String prefix) {
        if (template.getPattern().toLowerCase().startsWith(prefix.toLowerCase())) {
            return 1;
        }
        return 0;
    }

    protected Template[] getTemplates(String contextTypeId) {
        return TemplateEditorUI.getDefault().getTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return TemplateEditorUI.getDefault().getContextTypeRegistry().getContextType(this.fAssistant.getContextType());
    }

    protected Image getImage(Template template) {
        return DVTImages.imageCache.getImage(DVTImages.TEMPLATE_OBJ);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix;
        ITextSelection selection;
        block11: {
            block10: {
                if (!this.fCA || this.fOffset + 1 != offset) break block10;
                this.fCA = false;
                this.fOffset = offset;
                char c = viewer.getDocument().getChar(Math.max(0, offset - 1));
                if (Character.isJavaIdentifierPart(c)) break block10;
                return null;
            }
            this.fOffset = offset;
            this.fCA = false;
            selection = this.fAssistant.nonUiGetSelection(viewer);
            if (selection.getOffset() == offset) {
                offset = selection.getOffset() + selection.getLength();
            }
            if ((prefix = this.extractPrefix(viewer, offset)) != null) break block11;
            return null;
        }
        try {
            Region region = new Region(offset - prefix.length(), prefix.length());
            TemplateContext context = this.createContext(viewer, (IRegion)region);
            if (context == null) {
                return new ICompletionProposal[0];
            }
            context.setVariable("selection", selection.getText());
            Template[] templates = this.getTemplates(context.getContextType().getId());
            Template[] projectTemplates = this.getProjectTemplates();
            ArrayList<Template> allTemplates = new ArrayList<Template>();
            allTemplates.addAll(Arrays.asList(projectTemplates));
            allTemplates.addAll(Arrays.asList(templates));
            ArrayList<CustomTemplateProposal> matches = new ArrayList<CustomTemplateProposal>();
            for (Template template : allTemplates) {
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    continue;
                }
                if (!template.matches(prefix, context.getContextType().getId()) && !template.matches(prefix, "ro.amiq.msdldt.templates.contextType.unknown")) continue;
                CustomTemplateProposal proposal = this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix));
                proposal.firstLetterOfPrefixIsUppercase = prefix.isEmpty() ? false : Character.isUpperCase(prefix.charAt(0));
                matches.add(proposal);
            }
            Collections.sort(matches, fgProposalComparator);
            boolean ignoreCase = MSDLPlugin.getDefault().getPreferenceStore().getBoolean("ca.ignore_case");
            boolean camelCase = MSDLPlugin.getDefault().getPreferenceStore().getBoolean("ca.camel_case");
            boolean prefixMatch = MSDLPlugin.getDefault().getPreferenceStore().getBoolean("ca.prefix_match");
            int matchType = 0x20 | (ignoreCase ? 8 : 0) | (camelCase ? 4 : 0) | (prefixMatch || !camelCase ? 2 : 0);
            ArrayList<CustomTemplateProposal> proposals = new ArrayList<CustomTemplateProposal>();
            for (CustomTemplateProposal match : matches) {
                String templateName = match.getTemplateName().toLowerCase();
                if (!DVTStringUtil.regionMatches((String)(templateName = templateName.replace(' ', '_')), (String)prefix.toLowerCase(), (int)matchType)) continue;
                proposals.add(match);
            }
            this.fCA = true;
            return proposals.toArray(new ICompletionProposal[0]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected CustomTemplateProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return new CustomTemplateProposal(template, context, region, this.getImage(template), relevance);
    }

    /*
     * Exception decompiling
     */
    protected String extractPrefix(ITextViewer viewer, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IProject getProject() {
        if (this.fEditor == null) {
            return null;
        }
        if (!(this.fEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        return project;
    }

    private File getProjectTemplatesFile() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        return project.getLocation().append(".dvt").append(MSDL_CODE_TEMPLATES).toFile();
    }

    private Template[] getProjectTemplates() {
        File file = this.getProjectTemplatesFile();
        if (file == null || !file.exists() || file.length() == 0L) {
            return new Template[0];
        }
        Template[] result = this.getTemplatesFromFile(file);
        if (result == null) {
            return new Template[0];
        }
        return result;
    }

    private Template[] getTemplatesFromFile(File file) {
        TemplateReaderWriter templateReaderWriter = new TemplateReaderWriter();
        TemplatePersistenceData[] templatePersistenceData = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader fileReader = new BufferedReader(new FileReader(file));){
                templatePersistenceData = templateReaderWriter.read((Reader)fileReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (templatePersistenceData == null) {
            return null;
        }
        ArrayList<Template> result = new ArrayList<Template>();
        TemplatePersistenceData[] templatePersistenceDataArray = templatePersistenceData;
        int n = templatePersistenceData.length;
        int n2 = 0;
        while (n2 < n) {
            TemplatePersistenceData tpd = templatePersistenceDataArray[n2];
            if (tpd.isEnabled() && !tpd.isDeleted()) {
                result.add(tpd.getTemplate());
            }
            ++n2;
        }
        return result.toArray(new Template[result.size()]);
    }

    static class CustomTemplateProposal
    extends TemplateProposal
    implements ICompletionProposalExtension4,
    ICompletionProposalExtension6 {
        public boolean firstLetterOfPrefixIsUppercase;

        public CustomTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
            super(template, context, region, image, relevance);
        }

        public CustomTemplateProposal(Template template, TemplateContext context, IRegion region, Image image) {
            super(template, context, region, image);
        }

        public String getAdditionalProposalInfo() {
            String additionalProposalInfo = super.getAdditionalProposalInfo();
            return additionalProposalInfo.replaceAll("\n", "<br>");
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            try {
                boolean usePrefixCapitalization;
                DVTFileModificationValidator.validateEdit((ITextViewer)viewer);
                DVTProjectionViewer viewer2 = (DVTProjectionViewer)viewer;
                int capitalizationKeyworks = MSDLPlugin.getDefault().getPreferenceStore().getInt("format.capitalization.keywords");
                int capitalizationDataTypes = MSDLPlugin.getDefault().getPreferenceStore().getInt("format.capitalization.data_types");
                boolean bl = usePrefixCapitalization = capitalizationKeyworks == 1 && capitalizationDataTypes == 1;
                if (usePrefixCapitalization) {
                    if (this.firstLetterOfPrefixIsUppercase) {
                        MSDLPlugin.getDefault().getPreferenceStore().setValue("format.capitalization.keywords", 2);
                        MSDLPlugin.getDefault().getPreferenceStore().setValue("format.capitalization.data_types", 2);
                    } else {
                        MSDLPlugin.getDefault().getPreferenceStore().setValue("format.capitalization.keywords", 3);
                        MSDLPlugin.getDefault().getPreferenceStore().setValue("format.capitalization.data_types", 3);
                    }
                }
                String formattedPattern = TemplatesViewUtils.formatReplacementString(() -> new MSDLSourceViewerConfiguration(null), (Template)this.getTemplate(), (DVTEditor)viewer2.getEditor(), (int)offset);
                this.getTemplate().setPattern(formattedPattern);
                if (usePrefixCapitalization) {
                    MSDLPlugin.getDefault().getPreferenceStore().setValue("format.capitalization.keywords", 1);
                    MSDLPlugin.getDefault().getPreferenceStore().setValue("format.capitalization.data_types", 1);
                }
                super.apply(viewer, trigger, stateMask, offset);
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        public String getTemplateName() {
            return super.getTemplate().getName();
        }

        public boolean isAutoInsertable() {
            return this.getTemplate().isAutoInsertable();
        }

        public StyledString getStyledDisplayString() {
            StyledString displayString = new StyledString(this.getTemplateName());
            String description = this.getTemplate().getDescription();
            if (description != null && !description.isEmpty()) {
                displayString.append(" - " + description, StyledString.QUALIFIER_STYLER);
            }
            return displayString;
        }
    }

    private static final class ProposalComparator
    implements Comparator<ICompletionProposal> {
        private ProposalComparator() {
        }

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            return ((TemplateProposal)o2).getRelevance() - ((TemplateProposal)o1).getRelevance();
        }
    }
}

