/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.contentassist;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.ui.editor.MSDLSourceViewerConfiguration;
import ro.amiq.msdldt.ui.editor.contentassist.MSDLTemplateProposal;

public class RfLazyAutoInstanceProposal
implements ICompletionProposal,
ICompletionProposalExtension6 {
    private String fReplacementString;
    private String fDisplayString;
    private StyledString fStyledDisplayString;
    private Image fImage;
    private int fCursorPosition;
    private IContextInformation fContextInformation;
    private ITextViewer fTextViewer;
    private MSDLTemplateProposal fTemplateProposal;
    private IRfDesignElement fCandidate;
    private TemplateContext fContext;
    private IRegion fRegion;
    private LinkedHashMap<String, IRegion> fTemplates = new LinkedHashMap();
    private String fPrefix;

    public RfLazyAutoInstanceProposal(LinkedHashMap<String, IRegion> templates, ITextViewer viewer, TemplateContext context, IRfDesignElement candidate, boolean showLibrary, Image image, IContextInformation contextInformation, String currentWord) {
        this.fTextViewer = viewer;
        this.fCandidate = candidate;
        this.fPrefix = currentWord;
        this.fContextInformation = contextInformation;
        this.fDisplayString = this.fCandidate.getName();
        this.fStyledDisplayString = new StyledString(this.fDisplayString);
        if (showLibrary) {
            this.fStyledDisplayString.append(new StyledString(" - " + this.fCandidate.getEnclosingLibrary().getName(), StyledString.QUALIFIER_STYLER));
            this.fDisplayString = String.valueOf(this.fDisplayString) + " - " + this.fCandidate.getEnclosingLibrary().getName();
        }
        this.fImage = image;
        this.fCursorPosition = 0;
        this.fContext = context;
        this.fTemplates = templates;
        Iterator<Map.Entry<String, IRegion>> iterator = templates.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, IRegion> e = iterator.next();
            this.fRegion = e.getValue();
            this.fReplacementString = e.getKey();
        }
    }

    public void apply(IDocument document) {
        try {
            this.fTemplateProposal = null;
            LinkedHashMap<Template, IRegion> templates = new LinkedHashMap<Template, IRegion>();
            boolean mainTemplate = true;
            IEditorPart editor = this.fTextViewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)this.fTextViewer).getEditor() : DVTFileUtils.getInstance().getActiveEditor();
            DVTFileModificationValidator.validateEdit((ITextViewer)this.fTextViewer);
            for (Map.Entry<String, IRegion> e : this.fTemplates.entrySet()) {
                IRegion region = e.getValue();
                String replacementString = RfLazyAutoInstanceProposal.formatReplacementString(e.getKey(), region, this.fTextViewer, mainTemplate, null, this.fPrefix);
                templates.put(new Template("", this.fDisplayString, "ro.amiq.msdldt.templates.contextType.unknown", replacementString, true), region);
                mainTemplate = false;
            }
            this.fTemplateProposal = new MSDLTemplateProposal(templates, this.fContext, this.fImage, 1, DVTDocumentCommon.getLineDelimiter((IEditorPart)editor));
            this.fTemplateProposal.apply(this.fTextViewer, '\u0000', 0, this.fRegion.getOffset());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Point getSelection(IDocument document) {
        if (this.fTemplateProposal == null) {
            return new Point(this.fRegion.getOffset() + this.fCursorPosition, 0);
        }
        return this.fTemplateProposal.getSelection(document);
    }

    public IContextInformation getContextInformation() {
        if (this.fTemplateProposal == null) {
            return this.fContextInformation;
        }
        return this.fTemplateProposal.getContextInformation();
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getAdditionalProposalInfo() {
        if (this.fReplacementString.length() > 1000) {
            return String.valueOf(this.fReplacementString.substring(0, 600).replaceAll("\n", "<br>")) + "...";
        }
        return this.fReplacementString.replaceAll("\n", "<br>");
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    protected static String formatReplacementString(String replacementString, IRegion region, ITextViewer textViewer, boolean isInstanceTemplate, String additionalIndent, String prefix) {
        boolean usePrefixCapitalization;
        IPreferenceStore store = MSDLPlugin.getDefault().getPreferenceStore();
        boolean prevPreserveSLCommentColumnZero = store.getBoolean("format.indent.preserve_sl_comment_column_zero");
        boolean prevVerticalAlignment = store.getBoolean("format.vertical_align");
        String prevVerticalAlignTokens = store.getString("format.vertical_align.tokens");
        int capitalizationKeyworks = store.getInt("format.capitalization.keywords");
        int capitalizationDataTypes = store.getInt("format.capitalization.data_types");
        boolean bl = usePrefixCapitalization = capitalizationKeyworks == 1 && capitalizationDataTypes == 1;
        if (usePrefixCapitalization) {
            if (prefix != null && !prefix.isEmpty() && Character.isUpperCase(prefix.charAt(0))) {
                store.setValue("format.capitalization.keywords", 2);
                store.setValue("format.capitalization.data_types", 2);
            } else if (prefix != null && !prefix.isEmpty() && Character.isLowerCase(prefix.charAt(0))) {
                store.setValue("format.capitalization.keywords", 3);
                store.setValue("format.capitalization.data_types", 3);
            } else {
                usePrefixCapitalization = false;
            }
        }
        store.setValue("format.indent.preserve_sl_comment_column_zero", false);
        store.setValue("format.vertical_align", true);
        store.setValue("format.vertical_align.tokens", "=>");
        try {
            String tmpReplacementString;
            IDocument d = textViewer.getDocument();
            int offset = region.getOffset();
            int regionLine = d.getLineOfOffset(offset);
            int indentLine = isInstanceTemplate ? regionLine : regionLine - 1;
            String indent = DVTDocumentCommon.getIndentOfLine((IDocument)d, (int)indentLine, (int)offset);
            if (additionalIndent != null) {
                indent = String.valueOf(indent) + additionalIndent;
            }
            if (indent == null) {
                indent = "";
            }
            if ((tmpReplacementString = Utils.formatString(() -> new MSDLSourceViewerConfiguration(null), (String)(replacementString = replacementString.trim()), (IDocument)d, (String)indent, (boolean)isInstanceTemplate)) != null) {
                replacementString = tmpReplacementString;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        store.setValue("format.indent.preserve_sl_comment_column_zero", prevPreserveSLCommentColumnZero);
        store.setValue("format.vertical_align", prevVerticalAlignment);
        store.setValue("format.vertical_align.tokens", prevVerticalAlignTokens);
        if (usePrefixCapitalization) {
            store.setValue("format.capitalization.keywords", 1);
            store.setValue("format.capitalization.data_types", 1);
        }
        return replacementString;
    }

    public StyledString getStyledDisplayString() {
        return this.fStyledDisplayString;
    }
}

