/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.edit.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.ui.editor.MSDLPartitionScanner;
import ro.amiq.msdldt.ui.editor.MSDLSourceViewerConfiguration;

public class MSDLCodeAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final int TIME_THRESHOLD = 250;
    private MSDLSourceViewerConfiguration fConfiguration;
    private ISourceViewer fSourceViewer;
    private int TAB_SIZE = 4;
    private boolean fToggle = true;
    private boolean fUseSpacesNotTabs;
    private static final int PAREN_OFFSET = 0;
    private static final int BRACK_OFFSET = 1;
    private static final int CURLY_OFFSET = 2;
    private static final int QUOTE_OFFSET = 3;
    private static final int NR_AUTOINSERT_CHARACTERS = 4;
    private int[] fLastInsertedOffsets = new int[4];
    private int[] fFirstInsertedOffsets = new int[4];
    private int[] fCountOpen = new int[4];
    private char fPreviousChar;
    private char fPrePreviousChar;
    private Map<String, List<Long>> fCharTimestampMap = new HashMap<String, List<Long>>();
    private static Map<Character, Character> BRACKET_PAIR = new HashMap<Character, Character>();

    static {
        BRACKET_PAIR.put(Character.valueOf('['), Character.valueOf(']'));
        BRACKET_PAIR.put(Character.valueOf('('), Character.valueOf(')'));
        BRACKET_PAIR.put(Character.valueOf('{'), Character.valueOf('}'));
    }

    public MSDLCodeAutoEditStrategy(ISourceViewer sourceViewer, MSDLSourceViewerConfiguration configuration) {
        this.fSourceViewer = sourceViewer;
        this.fConfiguration = configuration;
        this.resetInsertedOffsets();
        this.resetCountOpen();
    }

    private int getCurrentContentType(IDocument document, int offset) {
        String contentType;
        block10: {
            block9: {
                block8: {
                    block7: {
                        contentType = ((IDocumentExtension3)document).getContentType("__msdl_partitioning", offset, false);
                        if (!contentType.equals("__dftl_partition_content_type")) break block7;
                        return 5;
                    }
                    if (!contentType.equals("__msdl_literal_interpol")) break block8;
                    return 4;
                }
                if (!contentType.equals("__msdl_ml_comment")) break block9;
                return 0;
            }
            if (!contentType.equals("__msdl_sl_comment")) break block10;
            return 1;
        }
        try {
            if (contentType.equals("__msdl_literal")) {
                return 2;
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return -1;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand c) {
        this.autoIndent(document, c);
        if (this.fSourceViewer.getSelectedRange().y == 0 && !this.pressedDelete(c.offset)) {
            this.autoDelete(document, c);
        }
        this.autoInsertAndEncloseBrackets(document, c);
        this.transformText(document, c);
    }

    private boolean pressedDelete(int documentCommandOffset) {
        StyledText styledText = this.fSourceViewer.getTextWidget();
        if (styledText == null) {
            return false;
        }
        return styledText.getCaretOffset() == documentCommandOffset;
    }

    private void autoIndent(IDocument document, DocumentCommand c) {
        if (document == null || c == null) {
            return;
        }
        if (MSDLPlugin.getDefault().getPreferenceStore().getBoolean("autoindent.disabled")) {
            super.customizeDocumentCommand(document, c);
            return;
        }
        if (this.isCopyPasteText(c.text) && c.text != null) {
            try {
                IRegion line = document.getLineInformationOfOffset(c.offset);
                c.text = this.reindentateCopyPastedCode(c, Math.max(c.offset - line.getOffset(), 0));
                return;
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (c.length != 0 || c.text == null) {
            return;
        }
        if (this.isLiteralPartition(document, c.offset) && c.offset > 0 && this.isLiteralPartition(document, c.offset - 1)) {
            return;
        }
        DVTDocumentCommon.RecoveryCommand rc = new DVTDocumentCommon.RecoveryCommand();
        rc.loadFrom(c);
        try {
            this.TAB_SIZE = this.fConfiguration.getTabWidth(this.fSourceViewer);
            this.fUseSpacesNotTabs = TextUtils.getEditorSpacesForTabs((IPreferenceStore)MSDLPlugin.getDefault().getCombinedPreferenceStore());
            boolean insertTabChar = c.text.equals("\t");
            if (this.fUseSpacesNotTabs) {
                c.text = TextUtils.replaceTabsWithSpaces((String)c.text, (int)this.TAB_SIZE);
            }
            IRegion line = document.getLineInformationOfOffset(c.offset);
            Region before = new Region(line.getOffset(), Math.max(c.offset - line.getOffset(), 0));
            IRegion beforePrev = this.getPreviousRegion(document, c);
            if (beforePrev == null) {
                beforePrev = before;
            }
            Region after = new Region(c.offset, line.getLength() + line.getOffset() - c.offset);
            boolean beforeWhitespaces = document.get(before.getOffset(), before.getLength()).trim().length() == 0;
            boolean beforeWhitespacesPrev = document.get(beforePrev.getOffset(), beforePrev.getLength()).trim().length() == 0;
            boolean afterStartsCloseCurly = this.checkStartCloseCurly(document, after.getOffset(), after.getLength());
            boolean insertStartsCloseCurly = false;
            boolean insertLowerThenTick = false;
            boolean insertTickGreaterThen = false;
            boolean insertBeforeTick = false;
            boolean insertEndsWithNewLine = false;
            FastPartitioner partitioner = null;
            Document insertDoc = null;
            Document beforeInsertDoc = null;
            if (!insertTabChar) {
                insertDoc = new Document(c.text);
                beforeInsertDoc = beforePrev == null ? new Document(c.text) : new Document(String.valueOf(document.get(beforePrev.getOffset(), c.offset - beforePrev.getOffset()).trim()) + c.text);
                int currentContentType = this.getCurrentContentType(document, c.offset);
                if (currentContentType == -1) {
                    return;
                }
                partitioner = new FastPartitioner((IPartitionTokenScanner)new MSDLPartitionScanner(), new String[]{"__msdl_sl_comment", "__msdl_ml_comment", "__msdl_literal", "__msdl_literal_interpol", "__dftl_partition_content_type"});
                ((IDocumentExtension3)insertDoc).setDocumentPartitioner("__msdl_partitioning", (IDocumentPartitioner)partitioner);
                partitioner.connect((IDocument)insertDoc);
                insertStartsCloseCurly = this.checkStartCloseCurly((IDocument)insertDoc, 0, insertDoc.getLength());
                insertEndsWithNewLine = this.checkEndsWithNewLine((IDocument)insertDoc);
            }
            String indent = "";
            indent = insertStartsCloseCurly && beforeWhitespaces ? this.getIndentOfLine2(document, Math.max(c.offset - 1, 0)) : this.getIndentOfLine1(beforeWhitespaces, document, c.offset);
            if ((insertStartsCloseCurly && beforeWhitespaces || insertEndsWithNewLine) && !insertTabChar && !insertBeforeTick && !insertLowerThenTick) {
                ArrayList<Indent> commands = this.indentInsertedText(beforeWhitespaces, afterStartsCloseCurly, indent, document, c.offset, (IDocument)insertDoc);
                if (partitioner != null) {
                    partitioner.disconnect();
                }
                if (commands != null && insertDoc != null) {
                    int i = commands.size() - 1;
                    while (i >= 0) {
                        Indent command = commands.get(i);
                        if (command.offset != 0 || command.length != 0 || command.indent.length() > 0) {
                            insertDoc.replace(command.offset, command.length, command.indent);
                        }
                        --i;
                    }
                }
                if (insertDoc != null) {
                    c.text = insertDoc.get();
                }
            }
            if (insertEndsWithNewLine) {
                int end = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)document, (int)after.getOffset(), (int)Math.max(after.getOffset() + after.getLength(), 0));
                c.length = end - after.getOffset();
            }
            if ((insertStartsCloseCurly || insertEndsWithNewLine) && beforeWhitespaces) {
                int end = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)document, (int)before.getOffset(), (int)Math.max(before.getOffset() + before.getLength(), 0));
                c.offset = before.getOffset();
                c.length += end - before.getOffset();
            }
            if ((insertTickGreaterThen || insertLowerThenTick) && beforeWhitespacesPrev && (c.text.trim().length() != 0 || insertEndsWithNewLine)) {
                int end = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)document, (int)beforePrev.getOffset(), (int)Math.max(beforePrev.getOffset() + beforePrev.getLength(), 0)) + c.offset - beforePrev.getOffset() - beforePrev.getLength();
                c.offset = beforePrev.getOffset();
                c.length += end - beforePrev.getOffset();
                if (beforeInsertDoc != null) {
                    c.text = beforeInsertDoc.get();
                } else {
                    c.length = c.text.length();
                }
            }
            if (insertTabChar && beforeWhitespaces) {
                int offset = line.getOffset();
                indent = "";
                indent = afterStartsCloseCurly ? this.getIndentOfLine2(document, Math.max(offset - 1, 0)) : this.getIndentOfLine1(beforeWhitespaces, document, offset);
                if (TextUtils.getLength((String)indent, (int)this.TAB_SIZE) > TextUtils.getLength((String)document.get(offset, c.offset - offset), (int)this.TAB_SIZE) || c.offset == line.getOffset() && this.fToggle) {
                    this.fToggle = false;
                    int end = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)document, (int)c.offset, (int)(offset + line.getLength()));
                    c.offset = offset;
                    c.length = end - offset;
                    c.text = indent;
                } else if (c.offset == line.getOffset() && !this.fToggle) {
                    this.fToggle = true;
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            rc.saveIn(c);
        }
    }

    private String reindentateCopyPastedCode(DocumentCommand c, int currentIndentationNr) {
        if (currentIndentationNr == 0) {
            return c.text;
        }
        StringBuilder result = new StringBuilder();
        String indentation = StringUtils.repeat((String)" ", (int)currentIndentationNr);
        String[] lines = c.text.split("\n");
        int firstLineNrWhitespaces = this.getNrWhitespaces(lines[0]);
        result.append(lines[0].substring(firstLineNrWhitespaces)).append("\n");
        int nrWhitespaces = 0;
        int minNrWhitespaces = firstLineNrWhitespaces;
        int i = 1;
        while (i < lines.length) {
            nrWhitespaces = this.getNrWhitespaces(lines[i]);
            minNrWhitespaces = Math.min(minNrWhitespaces, nrWhitespaces);
            result.append(indentation).append(lines[i].substring(firstLineNrWhitespaces)).append("\n");
            ++i;
        }
        if (firstLineNrWhitespaces == minNrWhitespaces) {
            return result.toString();
        }
        if (minNrWhitespaces > currentIndentationNr) {
            indentation = StringUtils.repeat((String)" ", (int)currentIndentationNr);
            result = new StringBuilder(lines[0].substring(firstLineNrWhitespaces - (firstLineNrWhitespaces - minNrWhitespaces))).append("\n");
        } else {
            indentation = StringUtils.repeat((String)" ", (int)(currentIndentationNr - (firstLineNrWhitespaces - minNrWhitespaces)));
            result = new StringBuilder(lines[0].substring(firstLineNrWhitespaces)).append("\n");
        }
        i = 1;
        while (i < lines.length) {
            result.append(indentation).append(lines[i].substring(minNrWhitespaces)).append("\n");
            ++i;
        }
        return result.toString();
    }

    private int getNrWhitespaces(String text) {
        int i = 0;
        while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        return i;
    }

    private boolean isCopyPasteText(String text) {
        return text.contains("\n") && text.length() > 2;
    }

    private void autoDelete(IDocument document, DocumentCommand c) {
        if (document == null || c == null) {
            return;
        }
        if (MSDLPlugin.getDefault().getPreferenceStore().getBoolean("autoindent.disabled")) {
            super.customizeDocumentCommand(document, c);
            return;
        }
        if (c.length == 0 || c.text == null || c.text.length() > 0) {
            return;
        }
        if (this.isLiteralPartition(document, c.offset) && c.offset > 0 && this.isLiteralPartition(document, c.offset - 1)) {
            return;
        }
        DVTDocumentCommon.RecoveryCommand rc = new DVTDocumentCommon.RecoveryCommand();
        rc.loadFrom(c);
        try {
            boolean beforeWhitespaces;
            IRegion line = document.getLineInformationOfOffset(c.offset);
            Region current = new Region(line.getOffset() + 1, Math.max(c.offset - line.getOffset(), 0));
            boolean bl = beforeWhitespaces = document.get(current.getOffset(), current.getLength()).trim().length() == 0;
            if (beforeWhitespaces) {
                int indentLength;
                c.length = indentLength = this.getIndentOfLine3(document, Math.max(c.offset, 0));
                c.offset -= c.length - 1;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            rc.saveIn(c);
        }
    }

    private void commandShiftCaret(DocumentCommand command) {
        command.shiftsCaret = false;
        command.caretOffset = command.offset + 1;
    }

    private boolean getPreferenceForAutoInsert(String commandText) {
        if (commandText == null || commandText.length() <= 0) {
            return false;
        }
        switch (commandText.charAt(0)) {
            case '(': {
                return MSDLPlugin.getDefault().getPreferenceStore().getBoolean("typing.paran_case");
            }
            case '[': {
                return MSDLPlugin.getDefault().getPreferenceStore().getBoolean("typing.brack_case");
            }
            case '{': {
                return MSDLPlugin.getDefault().getPreferenceStore().getBoolean("typing.curly_case");
            }
            case '\"': {
                return MSDLPlugin.getDefault().getPreferenceStore().getBoolean("typing.quote_case");
            }
        }
        return true;
    }

    private boolean getPreferenceForAutoEnclose(String commandText) {
        if (commandText == null || commandText.length() <= 0) {
            return false;
        }
        switch (commandText.charAt(0)) {
            case '(': {
                return MSDLPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.paran_case");
            }
            case '[': {
                return MSDLPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.brack_case");
            }
            case '{': {
                return MSDLPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.curly_case");
            }
            case '\"': {
                return MSDLPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.quote_case");
            }
        }
        return true;
    }

    private boolean isLiteralPartition(IDocument d, int offset) {
        String currentContentType;
        block3: {
            try {
                currentContentType = ((IDocumentExtension3)d).getContentType("__msdl_partitioning", offset, false);
                if (currentContentType != null) break block3;
                return false;
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
                return false;
            }
        }
        return currentContentType.equals("__msdl_literal");
    }

    private void resetInsertedOffsets() {
        int i = 0;
        while (i < 4) {
            this.fLastInsertedOffsets[i] = -1;
            this.fFirstInsertedOffsets[i] = Integer.MAX_VALUE;
            ++i;
        }
    }

    private void resetCountOpen() {
        int i = 0;
        while (i < 4) {
            this.fCountOpen[i] = 0;
            ++i;
        }
    }

    private void smartResetCountOpen(int offset) {
        int i = 0;
        while (i < 4) {
            if (offset < this.fFirstInsertedOffsets[i] || offset > this.fLastInsertedOffsets[i]) {
                this.fCountOpen[i] = 0;
            }
            ++i;
        }
    }

    private int getBracketType(char bracket) {
        switch (bracket) {
            case '(': 
            case ')': {
                return 0;
            }
            case '[': 
            case ']': {
                return 1;
            }
            case '{': 
            case '}': {
                return 2;
            }
            case '\"': {
                return 3;
            }
        }
        return -1;
    }

    private boolean conditionCloseAutoInsertBracket(char bracket, char afterChar, DocumentCommand command) {
        if (command == null || command.text == null) {
            return false;
        }
        int type = this.getBracketType(bracket);
        if (type == -1) {
            return false;
        }
        return command.text.equals(Character.toString(bracket)) && this.fLastInsertedOffsets[type] == command.offset + 1 && afterChar == bracket && this.fCountOpen[type] > 0;
    }

    private boolean conditionOpenAutoInsertBracket(char bracket, IDocument d, DocumentCommand command) {
        if (command == null || command.text == null || d == null) {
            return false;
        }
        boolean isFollowedByWhitespace = DVTDocumentCommon.isNotFollowedByIdentifier((IDocument)d, (int)command.offset);
        return command.text.equals(Character.toString(bracket)) && isFollowedByWhitespace && !this.isLiteralPartition(d, command.offset);
    }

    private int countEscapeNumber(IDocument d, DocumentCommand command, int index) {
        int count = 0;
        int i = index - 1;
        while (i >= 0) {
            if (TextUtils.getChar((IDocument)d, (int)(command.offset + i)) != '\\') break;
            ++count;
            --i;
        }
        return count;
    }

    private String encloseWithQuote(IDocument d, DocumentCommand command) {
        StringBuilder enclosedTextResult = new StringBuilder();
        int escapeNumber = 0;
        String lineSeparator = DVTDocumentCommon.getLineDelimiter((IEditorPart)(this.fConfiguration != null ? this.fConfiguration.getEditor() : DVTFileUtils.getInstance().getActiveEditor()));
        if (this.isLiteralPartition(d, command.offset) && TextUtils.getChar((IDocument)d, (int)command.offset) != '\"') {
            enclosedTextResult.append("\"");
        }
        int i = 0;
        while (i < command.length) {
            char currentChar = TextUtils.getChar((IDocument)d, (int)(command.offset + i));
            if (currentChar == '\"') {
                escapeNumber = this.countEscapeNumber(d, command, i);
                if (escapeNumber == 0 || escapeNumber % 2 == 0) {
                    enclosedTextResult.append("\\\"");
                } else {
                    enclosedTextResult.append(currentChar);
                }
            } else if (Character.toString(currentChar).equals("\r") || Character.toString(currentChar).equals("\n")) {
                char nextChar = TextUtils.getChar((IDocument)d, (int)(command.offset + i + 1));
                if (!Character.toString(currentChar).equals("\r") || !Character.toString(nextChar).equals("\n")) {
                    enclosedTextResult.append(" \\").append(lineSeparator);
                }
            } else {
                enclosedTextResult.append(currentChar);
            }
            ++i;
        }
        if (this.isLiteralPartition(d, command.offset + command.length - 1) && TextUtils.getChar((IDocument)d, (int)(command.offset + command.length - 1)) != '\"') {
            enclosedTextResult.append("\"");
        }
        return enclosedTextResult.toString();
    }

    private String computeEnclosedText(String bracket, IDocument d, DocumentCommand command) {
        StringBuilder enclosedTextResult = new StringBuilder(bracket);
        if (bracket.equals("\"")) {
            enclosedTextResult.append(this.encloseWithQuote(d, command));
        } else {
            int i = 0;
            while (i < command.length) {
                enclosedTextResult.append(TextUtils.getChar((IDocument)d, (int)(command.offset + i)));
                ++i;
            }
        }
        return this.encloseWithBracket(bracket, enclosedTextResult.toString());
    }

    private void initAutoInsert(char beforeChar, char afterChar, DocumentCommand command) {
        if (beforeChar == '(' && afterChar == ')') {
            this.fLastInsertedOffsets[0] = command.offset;
        }
        if (beforeChar == '[' && afterChar == ']') {
            this.fLastInsertedOffsets[1] = command.offset;
        }
        if (beforeChar == '{' && afterChar == '}') {
            this.fLastInsertedOffsets[2] = command.offset;
        }
        if (beforeChar == '\"' && afterChar == '\"') {
            this.fLastInsertedOffsets[3] = command.offset;
        }
        int i = 0;
        while (i < 4) {
            int n = i++;
            this.fLastInsertedOffsets[n] = this.fLastInsertedOffsets[n] + command.text.length();
        }
    }

    private String encloseWithBracket(String bracket, String text) {
        if ("(".equals(bracket)) {
            text = String.valueOf(text) + ")";
        } else if ("[".equals(bracket)) {
            text = String.valueOf(text) + "]";
        } else if ("{".equals(bracket)) {
            text = String.valueOf(text) + "}";
        } else if ("\"".equals(bracket)) {
            text = String.valueOf(text) + "\"";
        }
        return text;
    }

    private boolean autoEncloseWithBrackets(IDocument document, DocumentCommand command) {
        boolean isEnabledEncloseText = this.getPreferenceForAutoEnclose(command.text);
        if (!isEnabledEncloseText || "".equals(this.encloseWithBracket(command.text, ""))) {
            return false;
        }
        command.text = this.computeEnclosedText(command.text, document, command);
        return true;
    }

    private void autoAddNewLine(char ch, char beforeCh, char afterCh, IDocument document, DocumentCommand command) {
        boolean isEnabledAutoInsert = this.getPreferenceForAutoInsert(command.text);
        if (!isEnabledAutoInsert) {
            return;
        }
        if (DVTDocumentCommon.isTextNewLine((IDocument)document, (String)command.text) && BRACKET_PAIR.values().contains(Character.valueOf(ch)) && BRACKET_PAIR.containsKey(Character.valueOf(beforeCh)) && this.getPreferenceForAutoInsert(String.valueOf(beforeCh)) && afterCh != ch) {
            try {
                char ch2;
                int commandLine = document.getLineOfOffset(command.offset);
                String text = document.get(document.getLineOffset(commandLine), command.offset - document.getLineOffset(commandLine));
                String indentText = TemplatesViewUtils.determineOffsetIndentExclusive((String)text);
                String tabOrSpace = TextUtils.getIndentTab((boolean)this.fUseSpacesNotTabs, (int)this.TAB_SIZE);
                String lineSeparator = DVTDocumentCommon.getLineDelimiter((IEditorPart)(this.fConfiguration != null ? this.fConfiguration.getEditor() : DVTFileUtils.getInstance().getActiveEditor()));
                String replaceString = String.valueOf(lineSeparator) + tabOrSpace + indentText + lineSeparator + indentText + ch;
                int startOffset = command.offset + 1;
                while (startOffset < document.getLength()) {
                    ch2 = document.getChar(startOffset);
                    if (!Character.isWhitespace(ch2)) break;
                    ++startOffset;
                }
                while (startOffset < document.getLength()) {
                    ch2 = document.getChar(startOffset);
                    if (!Character.isJavaIdentifierPart(ch2)) break;
                    ++startOffset;
                }
                document.replace(command.offset, 1, replaceString);
                command.caretOffset = command.offset + indentText.length() + tabOrSpace.length() + lineSeparator.length();
                command.text = "";
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        } else if (DVTDocumentCommon.isTextNewLine((IDocument)document, (String)command.text) && this.isLiteralPartition(document, command.offset) && command.offset > 0 && this.isLiteralPartition(document, command.offset - 1)) {
            try {
                int commandLine = document.getLineOfOffset(command.offset);
                int relativeOffset = command.offset - document.getLineOffset(commandLine);
                String text = document.get(command.offset, document.getLineLength(commandLine) - relativeOffset);
                int length = text.length();
                int count = 0;
                while (beforeCh == '\\') {
                    beforeCh = TextUtils.getChar((IDocument)document, (int)(command.offset - ++count - 1));
                }
                if (length >= 1 && count % 2 == 0) {
                    text = text.substring(0, length - 1);
                    String quote = "\"";
                    String lineSeparator = DVTDocumentCommon.getLineDelimiter((IEditorPart)(this.fConfiguration != null ? this.fConfiguration.getEditor() : DVTFileUtils.getInstance().getActiveEditor()));
                    String textSeparator = " + \\";
                    int currentLineNr = document.getLineOfOffset(command.offset);
                    IRegion line = document.getLineInformation(currentLineNr);
                    int currentLineOffset = line.getOffset();
                    int endOfLineOffset = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)document, (int)currentLineOffset, (int)(currentLineOffset + line.getLength()));
                    String indent = document.get(currentLineOffset, endOfLineOffset - currentLineOffset);
                    if (this.shouldInsertTabAfterBackslash(document, currentLineOffset, document.getLineLength(commandLine))) {
                        indent = String.valueOf(indent) + TextUtils.getIndentTab((boolean)this.fUseSpacesNotTabs, (int)this.TAB_SIZE);
                    }
                    document.replace(command.offset, text.length(), String.valueOf(quote) + textSeparator + lineSeparator + indent + quote + text);
                    command.shiftsCaret = false;
                    command.caretOffset = command.offset + (String.valueOf(quote) + textSeparator + lineSeparator + indent + quote).length();
                    command.text = "";
                }
            }
            catch (BadPartitioningException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private boolean autoInsertPair(char ch, IDocument document, DocumentCommand command) {
        boolean isEnabledAutoInsert = this.getPreferenceForAutoInsert(command.text);
        if (!isEnabledAutoInsert) {
            return false;
        }
        boolean result = true;
        if (this.conditionCloseAutoInsertBracket(')', ch, command)) {
            this.commandShiftCaret(command);
            command.text = "";
            this.fCountOpen[0] = this.fCountOpen[0] - 1;
        } else if (this.conditionOpenAutoInsertBracket('(', document, command)) {
            this.commandShiftCaret(command);
            command.text = "()";
            this.fCountOpen[0] = this.fCountOpen[0] + 1;
            this.fFirstInsertedOffsets[0] = command.offset;
        } else if (this.conditionCloseAutoInsertBracket(']', ch, command)) {
            this.commandShiftCaret(command);
            command.text = "";
            this.fCountOpen[1] = this.fCountOpen[1] - 1;
        } else if (this.conditionOpenAutoInsertBracket('[', document, command)) {
            this.commandShiftCaret(command);
            command.text = "[]";
            this.fCountOpen[1] = this.fCountOpen[1] + 1;
            this.fFirstInsertedOffsets[1] = command.offset;
        } else if (this.conditionCloseAutoInsertBracket('}', ch, command)) {
            this.commandShiftCaret(command);
            command.text = "";
            this.fCountOpen[2] = this.fCountOpen[2] - 1;
        } else if (this.conditionOpenAutoInsertBracket('{', document, command)) {
            this.commandShiftCaret(command);
            command.text = "{}";
            this.fCountOpen[2] = this.fCountOpen[2] + 1;
            this.fFirstInsertedOffsets[2] = command.offset;
        } else if (this.conditionCloseAutoInsertBracket('\"', ch, command)) {
            this.commandShiftCaret(command);
            command.text = "";
            this.fCountOpen[3] = this.fCountOpen[3] - 1;
        } else if (this.conditionOpenAutoInsertBracket('\"', document, command)) {
            this.commandShiftCaret(command);
            command.text = "\"\"";
            this.fCountOpen[3] = this.fCountOpen[3] + 1;
            this.fFirstInsertedOffsets[3] = command.offset;
        } else {
            result = false;
        }
        return result;
    }

    private void autoInsertAndEncloseBrackets(IDocument document, DocumentCommand command) {
        if (document == null || command == null) {
            return;
        }
        char ch = TextUtils.getChar((IDocument)document, (int)command.offset);
        char beforeCh = TextUtils.getChar((IDocument)document, (int)(command.offset - 1));
        char afterCh = TextUtils.getChar((IDocument)document, (int)(command.offset + 1));
        this.initAutoInsert(beforeCh, ch, command);
        if (!(command.length == 0 && this.autoInsertPair(ch, document, command) || command.length > 0 && this.autoEncloseWithBrackets(document, command))) {
            if (DVTDocumentCommon.isTextNewLine((IDocument)document, (String)command.text)) {
                this.autoAddNewLine(ch, beforeCh, afterCh, document, command);
            } else {
                this.smartResetCountOpen(command.offset);
            }
        }
    }

    private IRegion getPreviousRegion(IDocument document, DocumentCommand c) {
        try {
            IRegion lineInfo = document.getLineInformationOfOffset(c.offset);
            String line = document.get(lineInfo.getOffset(), lineInfo.getLength());
            String lineTrim = line.trim();
            int lineTrimOffset = line.indexOf(lineTrim);
            Document d = null;
            int offset = c.offset - lineInfo.getOffset();
            if (lineTrimOffset <= offset && offset <= line.length()) {
                d = new Document(String.valueOf(line.substring(lineTrimOffset, offset)) + c.text);
                String docContent = d.get();
                if (docContent.startsWith("<'")) {
                    if (Character.isWhitespace(c.text.charAt(0))) {
                        return new Region(lineInfo.getOffset(), Math.max(offset - docContent.length() - lineTrim.indexOf("<'") - 1, 0));
                    }
                    return new Region(lineInfo.getOffset(), Math.max(offset - docContent.length() + 1, 0));
                }
                if (docContent.equals("'>")) {
                    int indexOpen = line.indexOf("<'");
                    if (indexOpen == -1) {
                        return new Region(lineInfo.getOffset(), Math.max(offset - 1, 0));
                    }
                    return new Region(lineInfo.getOffset(), indexOpen);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return null;
    }

    private void transformText(IDocument document, DocumentCommand command) {
        if (document == null || command == null) {
            return;
        }
        char ch = '\u0000';
        if (command.text.length() == 1) {
            ch = command.text.charAt(0);
        }
        long currentTimestamp = System.currentTimeMillis();
        boolean useWhitespace = MSDLPlugin.getDefault().getPreferenceStore().getBoolean("typing.transform_whitespace");
        if (ch == ';' && MSDLPlugin.getDefault().getPreferenceStore().getBoolean("typing.transform_semicolon_to_assign")) {
            if (this.fPreviousChar == ';' && this.fPrePreviousChar == ';' && currentTimestamp - this.fCharTimestampMap.get(String.valueOf(ch)).get(0) + (this.fCharTimestampMap.get(String.valueOf(ch)).get(0) - this.fCharTimestampMap.get(String.valueOf(ch)).get(1)) < 500L) {
                command.offset -= 2;
                command.text = useWhitespace ? " := " : ":=";
                command.length = 2;
                this.fCharTimestampMap.put(";", Arrays.asList(0L, 0L));
            } else if (this.fPreviousChar == ';') {
                Long previousTimestamp = this.fCharTimestampMap.get(String.valueOf(ch)).get(0);
                this.fCharTimestampMap.put(";", Arrays.asList(currentTimestamp, previousTimestamp));
            } else {
                this.fCharTimestampMap.put(";", Arrays.asList(currentTimestamp));
            }
        }
        this.fPrePreviousChar = this.fPreviousChar;
        this.fPreviousChar = ch;
    }

    private boolean checkEndsWithNewLine(IDocument d) {
        IRegion last;
        block3: {
            try {
                int lines = d.getNumberOfLines();
                last = d.getLineInformation(lines - 1);
                if (lines != 1) break block3;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return d.get(last.getOffset(), last.getLength()).trim().length() == 0;
    }

    private ArrayList<Indent> indentInsertedText(boolean beforeWhitespaces, boolean afterStartsCloseCurly, String indent, IDocument d, int offset, IDocument d1) {
        try {
            ArrayList<Indent> list = new ArrayList<Indent>();
            int lines = d1.getNumberOfLines();
            int i = 0;
            while (i < lines) {
                int end;
                IRegion line = d1.getLineInformation(i);
                Indent command = new Indent(0, 0, "");
                if (i == 0) {
                    end = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)d1, (int)line.getOffset(), (int)(line.getOffset() + line.getLength()));
                    command = new Indent(0, end, indent);
                }
                if (i == lines - 1 && afterStartsCloseCurly) {
                    end = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)d1, (int)line.getOffset(), (int)(line.getOffset() + line.getLength()));
                    indent = this.getIndentOfCorrespondingOpenCurly(list, d, Math.max(offset - 1, 0), d1, Math.min(line.getOffset() + line.getLength(), d1.getLength() - 1));
                    command = new Indent(line.getOffset(), end - line.getOffset(), indent);
                } else if (i > 0) {
                    end = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)d1, (int)line.getOffset(), (int)(line.getOffset() + line.getLength()));
                    if (this.checkStartCloseCurly(d1, line.getOffset(), line.getLength())) {
                        indent = this.getIndentOfCorrespondingOpenCurly(list, d, offset, d1, Math.max(line.getOffset() - 1, 0));
                    }
                    command = new Indent(line.getOffset(), end - line.getOffset(), indent);
                }
                if (this.containsOpenCurly(d1, line.getOffset(), line.getLength())) {
                    indent = String.valueOf(indent) + TextUtils.getIndentTab((boolean)this.fUseSpacesNotTabs, (int)this.TAB_SIZE);
                }
                list.add(command);
                ++i;
            }
            if (!beforeWhitespaces) {
                list.set(0, new Indent(0, 0, ""));
            }
            return list;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private String getIndentOfCorrespondingOpenCurly(ArrayList<Indent> commands, IDocument d1, int offset1, IDocument d2, int offset2) {
        try {
            int nested = -1;
            int i = offset1 + offset2 + 1;
            while (i >= 0) {
                int index;
                IDocument d = i > offset1 ? d2 : d1;
                char ch = d.getChar(index = i > offset1 ? i - offset1 - 1 : i);
                if (ch == '{' && this.isCodePartition(d, index)) {
                    ++nested;
                } else if (ch == '}' && this.isCodePartition(d, index)) {
                    --nested;
                }
                if (nested == 0 && i > offset1) {
                    return commands.get((int)d.getLineOfOffset((int)index)).indent;
                }
                if (nested == 0) {
                    IRegion info = d.getLineInformationOfOffset(index);
                    int start = info.getOffset();
                    int end = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)d, (int)start, (int)index);
                    String indent = d.get(start, end - start);
                    return indent;
                }
                --i;
            }
            return "";
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    private String getIndentOfLine1(boolean beforeWhitespaces, IDocument d, int start) {
        try {
            int number = d.getLineOfOffset(start);
            IRegion line = d.getLineInformation(number);
            int offset = line.getOffset();
            if (beforeWhitespaces) {
                --number;
            }
            int i = number;
            while (i >= 0) {
                line = d.getLineInformation(i);
                offset = line.getOffset();
                String sLine = d.get(line.getOffset(), line.getLength());
                String sLineTrim = sLine.trim();
                int index = sLine.indexOf(sLineTrim);
                String contentType = ((IDocumentExtension3)d).getContentType("__msdl_partitioning", offset + index, false);
                if (d.get(offset, line.getLength()).trim().length() > 0 && !contentType.equals("__msdl_sl_comment") && !contentType.equals("__msdl_ml_comment")) {
                    int end = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)d, (int)offset, (int)(offset + line.getLength()));
                    int close = -1;
                    int length = Math.max(Math.min(offset + line.getLength(), start) - offset, 0);
                    if (this.containsOpenCurly(d, offset, length) || this.endsInColon(d, offset, length) || this.shouldInsertTabAfterBackslash(d, offset, length)) {
                        return String.valueOf(d.get(offset, end - offset)) + TextUtils.getIndentTab((boolean)this.fUseSpacesNotTabs, (int)this.TAB_SIZE);
                    }
                    close = this.containsCloseCurly(d, offset, Math.max(Math.min(offset + line.getLength(), start) - offset, 0));
                    if (close > 0) {
                        return this.getIndentOfLine2(d, Math.max(close - 1, 0));
                    }
                    return d.get(offset, end - offset);
                }
                --i;
            }
            return "";
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    private String getIndentOfLine2(IDocument d, int offset) {
        try {
            int nested = -1;
            int i = offset;
            while (i >= 0) {
                char ch = d.getChar(i);
                if (ch == '{' && this.isCodePartition(d, i)) {
                    ++nested;
                } else if (ch == '}' && this.isCodePartition(d, i)) {
                    --nested;
                }
                if (nested == 0) {
                    IRegion info = d.getLineInformationOfOffset(i);
                    int start = info.getOffset();
                    int end = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)d, (int)start, (int)i);
                    String indent = d.get(start, end - start);
                    return indent;
                }
                --i;
            }
            return "";
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    private int getIndentOfLine3(IDocument d, int offset) {
        try {
            int number = d.getLineOfOffset(offset);
            IRegion line = d.getLineInformation(number);
            int lineOffset = line.getOffset();
            int currentNrWhitespaces = offset - lineOffset + 1;
            int i = number - 1;
            while (i >= 0) {
                line = d.getLineInformation(i);
                lineOffset = line.getOffset();
                if (this.isCodePartition(d, lineOffset)) {
                    String sLine = d.get(line.getOffset(), line.getLength());
                    String sLineTrim = sLine.trim();
                    int lineNrWhitespaces = sLine.indexOf(sLineTrim);
                    String contentType = ((IDocumentExtension3)d).getContentType("__msdl_partitioning", lineOffset + lineNrWhitespaces, false);
                    if (d.get(lineOffset, line.getLength()).trim().length() > 0 && !contentType.equals("__msdl_sl_comment") && currentNrWhitespaces > lineNrWhitespaces) {
                        return currentNrWhitespaces - lineNrWhitespaces;
                    }
                }
                --i;
            }
            return 1;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkStartCloseCurly(IDocument d, int offset, int length) {
        try {
            char ch;
            IRegion line = d.getLineInformationOfOffset(offset);
            length = Math.min(length, line.getLength());
            int i = offset;
            while (true) {
                if (i >= offset + length) {
                    return false;
                }
                ch = d.getChar(i);
                if (!Character.isWhitespace(ch)) break;
                ++i;
            }
            return ch == '}' && this.isCodePartition(d, i);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private boolean isCodePartition(IDocument d, int offset) throws BadLocationException, BadPartitioningException {
        String currentContentType = ((IDocumentExtension3)d).getContentType("__msdl_partitioning", offset, false);
        return currentContentType.equals("__dftl_partition_content_type") || currentContentType.equals("__msdl_literal_interpol");
    }

    private boolean isCommentPartition(IDocument d, int offset) throws BadLocationException, BadPartitioningException {
        String currentContentType = ((IDocumentExtension3)d).getContentType("__msdl_partitioning", offset, false);
        return currentContentType.equals("__msdl_sl_comment") || currentContentType.equals("__msdl_ml_comment");
    }

    private boolean containsOpenCurly(IDocument d, int offset, int length) throws BadLocationException, BadPartitioningException {
        int nested = 1;
        int i = offset + length;
        while (i > offset) {
            if (d.getChar(i - 1) == '}' && this.isCodePartition(d, i - 1)) {
                --nested;
            } else if (d.getChar(i - 1) == '{' && this.isCodePartition(d, i - 1)) {
                if (nested > 0) {
                    return true;
                }
                ++nested;
            }
            --i;
        }
        return false;
    }

    private boolean endsInColon(IDocument d, int offset, int length) throws BadLocationException, BadPartitioningException {
        int i = offset + length;
        while (i > offset) {
            if (d.getChar(i - 1) == ':' && this.isCodePartition(d, i - 1)) {
                return true;
            }
            if (!Character.isWhitespace(d.getChar(i - 1)) && !this.isCommentPartition(d, i - 1)) {
                return false;
            }
            --i;
        }
        return false;
    }

    private boolean shouldInsertTabAfterBackslash(IDocument d, int offset, int length) throws BadLocationException, BadPartitioningException {
        int i = offset + length;
        while (i > offset) {
            if (d.getChar(i - 1) == '\\' && this.isCodePartition(d, i - 1)) {
                int lineNumber = d.getLineOfOffset(i - 1);
                IRegion line = d.getLineInformation(lineNumber);
                int lineOffset = line.getOffset();
                int j = lineNumber - 1;
                while (j >= 0) {
                    line = d.getLineInformation(j);
                    lineOffset = line.getOffset();
                    if (this.isCodePartition(d, lineOffset)) {
                        String sLine = d.get(line.getOffset(), line.getLength());
                        String sLineTrim = sLine.trim();
                        int lineNrWhitespaces = sLine.indexOf(sLineTrim);
                        String contentType = ((IDocumentExtension3)d).getContentType("__msdl_partitioning", lineOffset + lineNrWhitespaces, false);
                        if (d.get(lineOffset, line.getLength()).trim().length() > 0 && !contentType.equals("__msdl_sl_comment") && !contentType.equals("__msdl_ml_comment")) {
                            int k = lineOffset + line.getLength();
                            while (k > lineOffset) {
                                if (d.getChar(k - 1) == '\\' && this.isCodePartition(d, k - 1)) {
                                    return false;
                                }
                                if (!Character.isWhitespace(d.getChar(k - 1)) && !this.isCommentPartition(d, k - 1)) {
                                    return true;
                                }
                                --k;
                            }
                        }
                    }
                    --j;
                }
                return true;
            }
            if (!Character.isWhitespace(d.getChar(i - 1)) && !this.isCommentPartition(d, i - 1)) {
                return false;
            }
            --i;
        }
        return false;
    }

    private int containsCloseCurly(IDocument d, int offset, int length) throws BadLocationException, BadPartitioningException {
        int i = offset + length;
        while (i > offset) {
            if (d.getChar(i - 1) == '}' && this.isCodePartition(d, i - 1)) {
                return i - 1;
            }
            --i;
        }
        return -1;
    }

    boolean startsCloseCurly(String text) {
        int start = 0;
        while (start < text.length()) {
            if (text.charAt(start) != ' ' && text.charAt(start) != '\t' && text.charAt(start) != '\f') break;
            ++start;
        }
        return start < text.length() ? text.charAt(start) == '}' : false;
    }

    static class Indent {
        int offset;
        int length;
        String indent;

        public Indent(int offset, int length, String indent) {
            this.offset = offset;
            this.length = length;
            this.indent = indent;
        }
    }
}

