/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.formatter;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.CFBeginIndentScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.ICFBeginIndentScannerImpl;
import ro.amiq.msdldt.ui.editor.formatter.MSDLCFIndentScanner;

public class MSDLCFBeginIndentationTokenScanner
extends MSDLCFIndentScanner
implements ICFBeginIndentScannerImpl {
    private CFBeginIndentScanner fCFBeginIndentScanner;
    private Set<Character> fNoCurlyOnSameLineChars;

    public MSDLCFBeginIndentationTokenScanner(CFModel model) {
        super(model);
    }

    @Override
    public void setCFTokenScanner(CFTokenScanner cfTokenScanner) {
        super.setCFTokenScanner(cfTokenScanner);
        this.fCFBeginIndentScanner = (CFBeginIndentScanner)cfTokenScanner;
    }

    @Override
    public void analyzeToken(CFToken token) {
        super.analyzeToken(token);
        if (!this.isInPreproc()) {
            String tokenValue = token.getValue();
            if (tokenValue == null) {
                return;
            }
            this.tryBeginPrefs(token);
        }
    }

    public boolean isBeginIndentation() {
        return true;
    }

    public boolean tryBeginPrefs(CFToken token) {
        if (this.fFormatPreferences.isBeginPrefNewLine() && !token.isFirstNWSTokenOnLine() && token.getTokenType() == 4 && "{".equals(token.getValue())) {
            CFChunk chunk = token.getEnclosingChunk();
            if (chunk == null) {
                return false;
            }
            CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
            if (lineInfo == null) {
                return false;
            }
            boolean tryNewLine = false;
            int closingCurlyOffsetInLineAfterWS = lineInfo.hasClosingCurly(token.getStartOffsetInChunk() + 1, chunk);
            if (closingCurlyOffsetInLineAfterWS == -1) {
                tryNewLine = true;
            } else if (this.fFormatPreferences.isLineWrapEnabled() && this.fCFBeginIndentScanner.exceedsLineWrap(closingCurlyOffsetInLineAfterWS, lineInfo)) {
                tryNewLine = true;
            }
            if (tryNewLine) {
                return this.fCFBeginIndentScanner.tryBeginOnNewLine(token);
            }
            return false;
        }
        if (this.fFormatPreferences.isBeginPrefSameLine() && token.isFirstNWSTokenOnLine() && token.getTokenType() == 4 && "{".equals(token.getValue())) {
            CFChunk chunk = token.getEnclosingChunk();
            if (chunk == null) {
                return false;
            }
            CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
            if (lineInfo == null) {
                return false;
            }
            int closingCurlyOffsetInLineAfterWS = lineInfo.hasClosingCurly(token.getStartOffsetInChunk() + 1, chunk);
            if (closingCurlyOffsetInLineAfterWS == -1) {
                return this.fCFBeginIndentScanner.tryBeginOnSameLine(token);
            }
        }
        return false;
    }

    public boolean allowBeginOnSameLine(CFToken token) {
        CFLineInfo prevLineInfo;
        if (this.fNoCurlyOnSameLineChars == null) {
            this.fNoCurlyOnSameLineChars = new HashSet<Character>();
            this.fNoCurlyOnSameLineChars.add(Character.valueOf('{'));
            this.fNoCurlyOnSameLineChars.add(Character.valueOf(';'));
        }
        if ((prevLineInfo = this.fModel.getPrevNonWhitespaceLine(token.getLineNo())) != null) {
            if (prevLineInfo.endsWithChars(this.fNoCurlyOnSameLineChars)) {
                return false;
            }
            String prevLineContent = prevLineInfo.getChunksContent();
            if (prevLineContent != null && "<'".equals(prevLineContent.trim())) {
                return false;
            }
        }
        return true;
    }
}

