/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.formatter;

import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScopeScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.msdldt.ui.editor.formatter.MSDLCFPreprocScanner;

public class MSDLCFScopeScanner
extends MSDLCFPreprocScanner {
    protected CFPreferences fFormatPreferences;
    protected int fWrapThreshold;
    private CFScopeScanner fCFScopeScanner;
    private boolean fPotentialAction;
    private boolean fPotentialElse;

    public MSDLCFScopeScanner(CFModel model) {
        super(model);
    }

    @Override
    public void setCFTokenScanner(CFTokenScanner cfTokenScanner) {
        super.setCFTokenScanner(cfTokenScanner);
        this.fCFScopeScanner = (CFScopeScanner)cfTokenScanner;
    }

    @Override
    public void startPartition(DVTBaseFormattingStrategy strategy) {
        super.startPartition(strategy);
        this.fFormatPreferences = strategy.getFormatPreferences();
        DVTSourceViewerConfiguration sourceViewerConfiguration = this.fStrategy.getSourceViewerConfiguration();
        this.fWrapThreshold = this.fFormatPreferences.getLineWrapThreshold(sourceViewerConfiguration.isPreview());
    }

    @Override
    public void startToken(CFToken token) {
        super.startToken(token);
        if (this.isInPreproc()) {
            return;
        }
        if (token == null) {
            return;
        }
        if (token.getTokenType() == 3 || token.getTokenType() == 30 || token.getTokenType() == 40) {
            return;
        }
        if (token.getTokenType() == 2 && this.fPotentialElse && "else".equals(token.getValue())) {
            return;
        }
        this.fCFScopeScanner.popShouldClose(token.isFirstNWSTokenOnLine());
    }

    @Override
    public void analyzeToken(CFToken token) {
        super.analyzeToken(token);
        if (this.isInPreproc()) {
            return;
        }
        if (token == null) {
            return;
        }
        block0 : switch (token.getTokenType()) {
            case 2: {
                if ("if".equals(token.getValue())) {
                    this.updateOnIf(token);
                    break;
                }
                if ("else".equals(token.getValue())) {
                    this.updateOnElse(token);
                    break;
                }
                if (!"case".equals(token.getValue())) break;
                this.updateOnCase(token);
                break;
            }
            case 4: {
                String tokenValue = token.getValue();
                if (tokenValue.length() != 1) break;
                char tokenChar = tokenValue.charAt(0);
                switch (tokenChar) {
                    case '[': {
                        this.fCFScopeScanner.updateOnBracketOpen(token);
                        break block0;
                    }
                    case ']': {
                        this.fCFScopeScanner.updateOnBracketClose(token);
                        break block0;
                    }
                    case '(': {
                        this.fCFScopeScanner.updateOnParenOpen(token);
                        break block0;
                    }
                    case ')': {
                        this.fCFScopeScanner.updateOnParenClose(token);
                        break block0;
                    }
                    case '{': {
                        this.updateOnCurlyOpen(token);
                        break block0;
                    }
                    case '}': {
                        this.updateOnCurlyClose(token);
                        break block0;
                    }
                    case ':': {
                        this.updateOnColon(token);
                    }
                }
            }
        }
    }

    @Override
    public void endToken(CFToken token) {
        super.endToken(token);
        if (this.isInPreproc()) {
            return;
        }
        if (token.getTokenType() != 3 && token.getTokenType() != 30 && token.getTokenType() != 40) {
            this.fPotentialAction = false;
            this.fPotentialElse = false;
        }
        if (token.getTokenType() == 4) {
            String tokenValue = token.getValue();
            if (tokenValue == null || tokenValue.isEmpty()) {
                return;
            }
            char tokenChar = tokenValue.charAt(0);
            switch (tokenChar) {
                case '{': {
                    this.fPotentialAction = true;
                    break;
                }
                case ';': {
                    this.fPotentialAction = true;
                    break;
                }
                case '}': {
                    CFScope peekScope = this.fCFScopeScanner.getPeekScope();
                    if (peekScope == null || !"if".equals(peekScope.getScopeName())) break;
                    this.fPotentialElse = true;
                }
            }
        }
    }

    public void updateOnCurlyOpen(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && peekScope.isShortScope()) {
            this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.GLUE_INDENT);
        } else {
            this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.INDENT);
        }
    }

    public void updateOnCurlyClose(CFToken token) {
        this.fCFScopeScanner.updateOnEndOfBlock(token, null);
    }

    private void updateOnIf(CFToken token) {
        if (this.fPotentialAction) {
            this.fCFScopeScanner.pushScope(token, "if", CFScope.SHORT_SCOPE, CFScope.INDENT);
        } else {
            CFScope peekScope = this.fCFScopeScanner.getPeekScope();
            if (peekScope != null && "else".equals(peekScope.getScopeName())) {
                if (this.fCFScopeScanner.isOnTheSameLineWithCurrentScope(token)) {
                    peekScope.setScopeName("if");
                    return;
                }
                this.fCFScopeScanner.pushScope(token, "if", CFScope.SHORT_SCOPE, CFScope.INDENT);
            }
        }
    }

    private void updateOnElse(CFToken token) {
        if (this.fPotentialElse) {
            CFScope peekScope = this.fCFScopeScanner.getPeekScope();
            if (peekScope != null && peekScope.shouldClose()) {
                this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            }
            this.fCFScopeScanner.pushScope(token, "else", CFScope.SHORT_SCOPE, CFScope.INDENT);
        }
    }

    private void updateOnCase(CFToken token) {
        if (this.fPotentialAction) {
            this.fCFScopeScanner.pushScope(token, "case", CFScope.SHORT_SCOPE, CFScope.INDENT);
        }
    }

    private void updateOnColon(CFToken token) {
        CFScope prePeekScope = this.fCFScopeScanner.getPrePeekScope();
        if (prePeekScope == null) {
            return;
        }
        if ("case".equals(prePeekScope.getScopeName())) {
            this.fCFScopeScanner.pushScope(token, ":", CFScope.SHORT_SCOPE, CFScope.INDENT);
        }
    }
}

