/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.highlight;

import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.msdldt.model.reflection.FieldModifier;
import ro.amiq.msdldt.model.reflection.RfCovergroup;
import ro.amiq.msdldt.model.reflection.RfEnumItem;
import ro.amiq.msdldt.model.reflection.RfEnumType;
import ro.amiq.msdldt.model.reflection.RfEvent;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfMethod;
import ro.amiq.msdldt.model.reflection.RfPackage;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.RfTypeAlias;
import ro.amiq.msdldt.model.reflection.StructKind;

public class MSDLHlUtils
extends DVTHlUtils {
    public static HighlightKind getHighlightKind(Object element, boolean isDeclaration) {
        if (element instanceof RfStruct) {
            StructKind structKind = ((RfStruct)element).getStructKind();
            if (structKind == StructKind.ACTOR) {
                return HighlightKind.MSDL_ACTOR;
            }
            if (isDeclaration && structKind == StructKind.SCENARIO) {
                return HighlightKind.MSDL_SCENARIO_DECL;
            }
            if (structKind == StructKind.SCENARIO) {
                return HighlightKind.MSDL_SCENARIO;
            }
            if (isDeclaration && structKind == StructKind.MODIFIER) {
                return HighlightKind.MSDL_MODIFIER_DECL;
            }
            if (structKind == StructKind.MODIFIER) {
                return HighlightKind.MSDL_MODIFIER;
            }
            return HighlightKind.TYPE;
        }
        if (element instanceof RfEnumType || element instanceof RfTypeAlias || element instanceof RfStruct || element instanceof RfPackage || element instanceof RfCovergroup) {
            return HighlightKind.TYPE;
        }
        if (element instanceof RfEnumItem) {
            return HighlightKind.MSDL_ENUM_ITEM;
        }
        if (element instanceof RfMethod) {
            return HighlightKind.METHOD;
        }
        if (element instanceof RfField) {
            RfField field = (RfField)element;
            FieldModifier fieldModifier = field.getFieldModifier();
            if (fieldModifier == FieldModifier.PARAMETER) {
                return HighlightKind.ARGUMENT;
            }
            if (fieldModifier == FieldModifier.SCENARIO_INVOCATION) {
                return HighlightKind.LABEL;
            }
            return HighlightKind.FIELD;
        }
        if (element instanceof RfEvent) {
            return HighlightKind.EVENT;
        }
        return HighlightKind.DEFAULT;
    }
}

