/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.hover;

import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import ro.amiq.msdldt.ui.editor.MSDLCodeScanner;
import ro.amiq.msdldt.ui.editor.MSDLCommentScanner;
import ro.amiq.msdldt.ui.editor.MSDLStyle;
import ro.amiq.msdldt.ui.editor.hover.MSDLHoverNonRuleBasedReconciler;
import ro.amiq.msdldt.ui.editor.hover.MSDLHoverSourceViewerReconciler;

public class MSDLHoverSourceViewerConfiguration
extends SourceViewerConfiguration {
    private MSDLCodeScanner fCodeScanner;
    private MSDLCommentScanner fCommentScanner;
    private MSDLStyle fColorManager;

    public MSDLHoverSourceViewerConfiguration(MSDLStyle colorManager) {
        this.fColorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__msdl_literal", "__msdl_literal_interpol", "__msdl_sl_comment", "__msdl_ml_comment"};
    }

    protected MSDLCodeScanner getCodeScanner() {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new MSDLCodeScanner(this.fColorManager, 0);
            this.fCodeScanner.setDefaultReturnToken(this.fColorManager.getToken("highlight.default"));
        }
        return this.fCodeScanner;
    }

    protected MSDLCommentScanner getCommentScanner() {
        if (this.fCommentScanner == null) {
            this.fCommentScanner = new MSDLCommentScanner(this.fColorManager, false, 0, false, null);
            this.fCommentScanner.setDefaultReturnToken(this.fColorManager.getToken("highlight.default"));
        }
        return this.fCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        MSDLHoverSourceViewerReconciler dr1 = new MSDLHoverSourceViewerReconciler((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr1, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr1, "__dftl_partition_content_type");
        MSDLHoverSourceViewerReconciler dr2 = new MSDLHoverSourceViewerReconciler((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr2, "__msdl_sl_comment");
        reconciler.setRepairer((IPresentationRepairer)dr2, "__msdl_sl_comment");
        MSDLHoverSourceViewerReconciler dr3 = new MSDLHoverSourceViewerReconciler((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr3, "__msdl_ml_comment");
        reconciler.setRepairer((IPresentationRepairer)dr3, "__msdl_ml_comment");
        MSDLHoverNonRuleBasedReconciler ndr1 = new MSDLHoverNonRuleBasedReconciler(this.fColorManager, "highlight.string");
        reconciler.setDamager((IPresentationDamager)ndr1, "__msdl_literal");
        reconciler.setRepairer((IPresentationRepairer)ndr1, "__msdl_literal");
        return reconciler;
    }
}

