/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.hover;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.debug.ui.editor.hover.ITextHoverParticipant;
import ro.amiq.dvt.model.problems.MSDLProblemCategories;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.hover.DVTInformationControl;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.ui.editor.hover.IDVTHover;
import ro.amiq.dvt.ui.editor.problem.hover.DVTProblemHoverUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.msdldt.ui.editor.hover.MSDLProblemHover;

public class MSDLTextHover
implements IDVTHover,
ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private ITextEditor fTextEditor;
    private ArrayList<ITextHoverParticipant> fTextHoverParticipants = new ArrayList();
    private MSDLProblemHover problemHover;
    private IRegion currentHoverRegion;

    public MSDLTextHover(ITextEditor editor) {
        this.fTextEditor = editor;
        this.problemHover = new MSDLProblemHover((DVTEditor)this.fTextEditor);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion region) {
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion region) {
        this.currentHoverRegion = region;
        DVTTooltipContent tooltipContent = this.makeInfo(textViewer, region, this.fTextHoverParticipants);
        String tooltipInfo = String.valueOf(tooltipContent.getSignature()) + tooltipContent.getShallow() + tooltipContent.getComment() + tooltipContent.getUPFSignature() + tooltipContent.getDebugInfo();
        tooltipInfo = DVTStringUtil.breakLongNonWhitespaceSequences((String)tooltipInfo, (int)400, (char)'\n');
        if (DVTProblemHoverUtils.shouldShowQuickFixLinks((ITextEditor)this.fTextEditor, (IRegion)region, (Set)MSDLProblemCategories.ALL_PROBLEMS)) {
            this.problemHover.setExtraTooltipInfo(tooltipInfo);
            return this.problemHover.getHoverInfo2(textViewer, region);
        }
        return tooltipInfo;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (DVTProblemHoverUtils.shouldShowQuickFixLinks((ITextEditor)this.fTextEditor, (IRegion)this.currentHoverRegion, (Set)MSDLProblemCategories.ALL_PROBLEMS)) {
            return this.problemHover.getHoverControlCreator();
        }
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DVTInformationControl(parent, "Press 'F2' to focus");
            }
        };
    }

    public void addTextHoverParticipant(ITextHoverParticipant textHoverParticipant) {
        textHoverParticipant.setTextEditor(this.fTextEditor);
        this.fTextHoverParticipants.add(textHoverParticipant);
    }

    public void removeTextHoverParticipant(ITextHoverParticipant textHoverParticipant) {
        this.fTextHoverParticipants.remove(textHoverParticipant);
    }
}

