/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.hyperlink;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.msdldt.ui.editor.hyperlink.ActionHyperlink;
import ro.amiq.msdldt.utils.MSDLFileUtils;

public class ImportHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;
    private DVTStringBuilder fText;

    public ImportHyperlinkDetector(ITextEditor editor) {
        this.fTextEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || this.fTextEditor == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        final IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        int offset = region.getOffset();
        IRegion wordRegion = this.selectWord(document, offset);
        if (wordRegion == null || wordRegion.getLength() == 0) {
            return null;
        }
        String knownPath = this.fText.toString();
        IPath fromPath = file.getLocation().removeLastSegments(1);
        final IProject finalProject = project;
        String replaced = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)knownPath, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, new DVTUtilsCommon.IEnvironmentProvider(){

            public String getenv(String name) {
                return (String)BuildConfigManager.getenv((IProject)project).get(name);
            }
        });
        replaced = replaced != null ? replaced : knownPath;
        IPath replacedPath = Path.fromOSString((String)replaced);
        if (replacedPath.getFileExtension() == null) {
            replacedPath = replacedPath.addFileExtension("sdl");
        }
        if (!replacedPath.isAbsolute()) {
            replacedPath = fromPath.append(replacedPath);
        }
        final String finalKnownPath = replacedPath.toOSString();
        IFileInfo fileInfo = DVTAutoLinkManager.getInstance().fetchFileInfo(replacedPath);
        if (fileInfo == null || !fileInfo.exists()) {
            return null;
        }
        Action openAction = new Action(){

            public void run() {
                MSDLFileUtils.getInstance().openFile(finalProject, finalKnownPath, 1, null);
            }
        };
        return new IHyperlink[]{new ImportHyperlink(wordRegion, knownPath, (IAction)openAction)};
    }

    private IRegion selectWord(IDocument document, int anchor) {
        int start;
        char c;
        int offset;
        block10: {
            this.fText = new DVTStringBuilder();
            offset = anchor;
            while (offset >= 0) {
                c = document.getChar(offset);
                if (Character.isWhitespace(c) || c == ';' || c == ',' || c == '(') break;
                this.fText.prepend(c);
                --offset;
            }
            start = offset--;
            boolean foundImport = false;
            DVTStringBuilder matchImport = new DVTStringBuilder();
            while (offset >= 0) {
                c = document.getChar(offset);
                if (c == ';') break;
                matchImport.prepend(c);
                if (matchImport.length() > 6) {
                    matchImport.deleteLastChar();
                }
                if (matchImport.toString().equals("import")) {
                    foundImport = true;
                    break;
                }
                --offset;
            }
            if (foundImport) break block10;
            return null;
        }
        try {
            int end;
            offset = anchor;
            int length = document.getLength();
            while (offset < length) {
                c = document.getChar(offset);
                if (Character.isWhitespace(c) || c == ';' || c == ',' || c == ')') break;
                if (offset != anchor) {
                    this.fText.append(c);
                }
                ++offset;
            }
            if (start == (end = offset)) {
                return new Region(start, 0);
            }
            return new Region(start + 1, end - start - 1);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    static class ImportHyperlink
    extends ActionHyperlink {
        private String fKnownPath;

        public ImportHyperlink(IRegion region, String knownPath, IAction action) {
            super(region, action);
            this.fKnownPath = knownPath;
        }

        @Override
        public String getHyperlinkText() {
            return DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.jumpToFile, (Object[])new Object[]{this.fKnownPath});
        }
    }
}

