/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IDVTHyperlink;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkDetector;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkUtils;
import ro.amiq.dvt.ui.editor.hyperlink.IActionHyperlink;
import ro.amiq.dvt.ui.views.layers.QuickLayersViewHandler;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.msdldt.model.reflection.IRfScope;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.util.RfUtils;
import ro.amiq.msdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.msdldt.ui.editor.MSDLEditor;
import ro.amiq.msdldt.ui.editor.MSDLWordFinder;
import ro.amiq.msdldt.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.msdldt.ui.editor.actions.ShowInstancesAction;
import ro.amiq.msdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.msdldt.ui.search.ReferenceSearchPageInput;
import ro.amiq.msdldt.ui.search.SearchQueryProvider;

public class RfHyperlinkDetector
extends DVTHyperlinkDetector {
    public RfHyperlinkDetector(ITextEditor editor) {
        this.fTextEditor = editor;
    }

    public IDVTHyperlink[] detectHyperlinksInternal(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || !(this.fTextEditor instanceof MSDLEditor)) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        if (!(this.fTextEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)this.fTextEditor.getEditorInput()).getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        int offset = Math.min(region.getOffset() + 1, document.getLength() - 1);
        ArrayList<IDVTHyperlink> hyperlinks = new ArrayList<IDVTHyperlink>();
        boolean isHyperlinkRunTimeInfoEnabled = BuildConfigManager.isDebugHyperlinkRunTimeInfo((IProject)project);
        long start = System.currentTimeMillis();
        List<RfWNamedElementAndScope> elementsAndScope = RfUtils.getRfElements(this.fTextEditor, document, offset);
        if (isHyperlinkRunTimeInfoEnabled) {
            DVTHyperlinkUtils.getInstance().reportHyperlinkElementFromCursorBenchmark(System.currentTimeMillis() - start);
        }
        start = System.currentTimeMillis();
        try {
            IRegion hyperlinkRegion;
            IRfScope scope;
            if (elementsAndScope == null || elementsAndScope.isEmpty()) {
                return null;
            }
            RfWNamedElementAndScope elementAndScope = elementsAndScope.get(0);
            IRfNamedElement element = elementAndScope.getIRfNamedElement();
            RfNamedElementActionHyperlink hyperlinkAction = RfUtils.getRfNamedElementActionHyperlink(project, element, scope = elementAndScope.getScope(), hyperlinkRegion = MSDLWordFinder.getDefault().getWordAtOffset(document, offset));
            if (hyperlinkAction == null) {
                return null;
            }
            IDVTHyperlink openDeclaration = this.createHyperlink(hyperlinkAction, DVTHyperlinkMessages.openDeclaration);
            ArrayList<IDVTHyperlink> otherDeclarationHyperlinks = new ArrayList<IDVTHyperlink>();
            boolean hasMultipleMethodHyperlinks = false;
            if (elementsAndScope.size() > 1) {
                int i = 0;
                while (i < elementsAndScope.size()) {
                    IRfNamedElement otherDeclElement = elementsAndScope.get(i).getIRfNamedElement();
                    IRfScope otherDeclScope = elementsAndScope.get(i).getScope();
                    hasMultipleMethodHyperlinks = true;
                    IRegion otherDeclHyperlinkRegion = MSDLWordFinder.getDefault().getWordAtOffset(document, offset);
                    RfNamedElementActionHyperlink otherDeclHyperlinkAction = RfUtils.getRfNamedElementActionHyperlink(project, otherDeclElement, otherDeclScope, otherDeclHyperlinkRegion);
                    if (otherDeclHyperlinkAction != null) {
                        otherDeclarationHyperlinks.add(this.createHyperlink(otherDeclHyperlinkAction, String.valueOf(DVTHyperlinkMessages.openDeclaration) + " '" + otherDeclElement.getSignature() + "'"));
                    }
                    ++i;
                }
            }
            DVTUtilsCommon.INSTANCE.showHyperlinkAction(element.getDeclaration(), element.getName(), offset, file.getLocation());
            IDVTHyperlink showUsages = this.createUsagesHyperlink(hyperlinkAction);
            List<RfNamedElementActionHyperlink> entityAndArchitectureActions = RfUtils.getEntityAndArchitectureHyperlinks(project, elementAndScope, hyperlinkAction.getHyperlinkRegion());
            if (entityAndArchitectureActions.isEmpty()) {
                entityAndArchitectureActions = RfUtils.getPossibleEntitiesAndArchitecturesHyperlinks(this.fTextEditor, project, document, offset);
            }
            if (canShowMultipleHyperlinks && !entityAndArchitectureActions.isEmpty()) {
                for (RfNamedElementActionHyperlink action : entityAndArchitectureActions) {
                    if (action == null) continue;
                    action.getRfNamedElement();
                }
                hyperlinks.add(openDeclaration);
            } else if (canShowMultipleHyperlinks) {
                if (hasMultipleMethodHyperlinks) {
                    for (IDVTHyperlink otherDeclHyperlink : otherDeclarationHyperlinks) {
                        hyperlinks.add(otherDeclHyperlink);
                    }
                    hyperlinks.add(this.createShowOverloadHyperlink(hyperlinkAction));
                } else {
                    hyperlinks.add(openDeclaration);
                    RfNamedElementActionHyperlink associatedTypeAction = RfUtils.getAssociatedTypeHyperlink(project, element, hyperlinkAction.getHyperlinkRegion());
                    if (associatedTypeAction != null) {
                        String labelType = RfUtils.getAssociatedTypeHyperlinkLabelPart(element);
                        String hyperlinkLabel = labelType.isEmpty() ? DVTHyperlinkMessages.openEmptyTypeDeclaration : DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openTypeDeclaration, (Object[])new Object[]{labelType});
                        hyperlinks.add(this.createHyperlink(associatedTypeAction, hyperlinkLabel));
                    }
                }
            } else {
                hyperlinks.add(openDeclaration);
            }
            this.createShowInstancesHyperlink(hyperlinkAction, hyperlinks, element);
            hyperlinks.add(showUsages);
            IDVTHyperlink[] iDVTHyperlinkArray = hyperlinks.toArray(new IDVTHyperlink[hyperlinks.size()]);
            return iDVTHyperlinkArray;
        }
        finally {
            if (isHyperlinkRunTimeInfoEnabled) {
                DVTHyperlinkUtils.getInstance().reportHyperlinkProposalsBenchmark(System.currentTimeMillis() - start);
            }
        }
    }

    private void createShowInstancesHyperlink(RfNamedElementActionHyperlink hyperlink, List<IDVTHyperlink> links, IRfNamedElement namedElement) {
        boolean canHaveInstances = RfSearchUtils.isInstantiable((IRfNamedElement)namedElement);
        if (!canHaveInstances) {
            return;
        }
        links.add(this.createInstancesHyperlink(hyperlink, namedElement));
    }

    private IDVTHyperlink createInstancesHyperlink(final RfNamedElementActionHyperlink hyperlinkAction, final IRfNamedElement element) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showInstances;
            }

            public void updateGuiPart() {
                ShowInstancesAction.showInstances(element);
            }

            public boolean updateNonGuiPart() {
                return true;
            }
        };
    }

    private IDVTHyperlink createShowOverloadHyperlink(final RfNamedElementActionHyperlink hyperlinkAction) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showOverload;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                try {
                    new QuickLayersViewHandler().execute(null);
                }
                catch (ExecutionException executionException) {}
            }
        };
    }

    private IDVTHyperlink createUsagesHyperlink(final RfNamedElementActionHyperlink hyperlinkAction) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showUsages;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                try {
                    IProject project = hyperlinkAction.getProject();
                    RfProject rfProject = RfManager.getInstance().getRfProject(project);
                    String[] fileExtensions = ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
                    FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
                    ReferenceSearchPageInput input = new ReferenceSearchPageInput(hyperlinkAction.getRfNamedElement(), true, false, true, searchScope);
                    ISearchQuery query = new SearchQueryProvider(1, 4, false, true).createQuery((TextSearchQueryProvider.TextSearchInput)input);
                    if (query != null) {
                        NewSearchUI.runQueryInBackground((ISearchQuery)query);
                    }
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        };
    }

    protected void openShowInstances(IRfNamedElement element) {
    }

    protected void openShowInstancesInDH(IRfNamedElement element) {
    }

    protected IActionHyperlink createOpenAction(IRfInstanceElement targetNamedElement, IProject project, IRegion region) {
        return null;
    }

    protected void openShowReadersUsages(IActionHyperlink hyperlink) {
    }

    protected void openShowWritersUsages(IActionHyperlink hyperlink) {
    }

    protected void setDataForBreadcrumb(IActionHyperlink hyperlinkAction, String label) {
    }

    protected LanguageKind getSourceLanguageKind() {
        return LanguageKind.MSDL;
    }

    public DVTWordFinder getWordFinder() {
        return MSDLWordFinder.getDefault();
    }

    public List<String> getDefaultHyperlinks() {
        return DVTHyperlinkMessages.getELANGDefaultHyperlinks();
    }
}

