/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.lazy.outline;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.lazy.outline.AbstractLazyOutlineProvider;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.model.reflection.FieldModifier;
import ro.amiq.msdldt.model.reflection.RfCovergroup;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfKind;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.views.OutlineTreeViewProvider;
import ro.amiq.msdldt.ui.editor.lazy.outline.MSDLOutlineUtil;

public class MSDLLazyOutlineProvider
extends AbstractLazyOutlineProvider {
    public static final Map<String, String> MSDL_OUTLINE_FIELDS = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("Show scenarios", "outline.show_actions");
            this.put("Show actors", "outline.show_components");
            this.put("Show constraints", "outline.show_constraints");
            this.put("Show covergroups", "outline.show_covergroups");
            this.put("Show fields", "outline.show_fields");
            this.put("Show functions", "outline.show_functions");
            this.put("Show labeled blocks", "outline.show_blocks");
            this.put("Show packages", "outline.show_packages");
            this.put("Show structs", "outline.show_structs");
            this.put("Show types", "outline.show_types");
        }
    };

    public MSDLLazyOutlineProvider(DVTEditor editor) {
        super(editor);
        this.labelProvider = new OutlineTreeViewProvider();
    }

    public IRfFileDef getFileDef() {
        if (this.editor == null) {
            return null;
        }
        IFile currentFile = this.editor.getCurrentFile();
        if (currentFile == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(this.editor.getProject());
        if (rfProject == null) {
            return null;
        }
        return rfProject.getFile((IResource)currentFile);
    }

    public boolean isOutlineElement(IRfDefElement def) {
        return MSDLOutlineUtil.INSTANCE.isOutlineElement(def);
    }

    public DVTGUIFilterMatcher.GUIFilterResult getFilterResult(IRfDefElement element) {
        return MSDLOutlineUtil.INSTANCE.getFilterResult(element);
    }

    public boolean isUnnamedBlock(IRfDefElement def) {
        return MSDLOutlineUtil.INSTANCE.isUnnamedBlock(def);
    }

    public boolean isPossibleOutlineParent(IRfDefElement def) {
        return MSDLOutlineUtil.INSTANCE.isPossibleOutlineParent(def);
    }

    public int getCategory(IRfDefElement def) {
        IRfNamedElement namedElem = def.getNamedElement();
        RfKind kind = RfKind.of(namedElem);
        return kind.ordinal();
    }

    public Collection<?> getChildren(IRfDefElement root) {
        RfDefElement declaration;
        RfNamedElement assocType;
        FieldModifier fieldModifier;
        IRfNamedElement rootNamedElement = root.getNamedElement();
        if (rootNamedElement == null) {
            return null;
        }
        Collection<RfDefElement> children = root.getChildren();
        if (rootNamedElement instanceof RfField && (fieldModifier = ((RfField)rootNamedElement).getFieldModifier()) == FieldModifier.COVERGROUP_INLINE && (assocType = ((RfField)rootNamedElement).getAssociatedType()) instanceof RfCovergroup && (declaration = assocType.getDeclaration()) != null) {
            children = declaration.getChildren();
        }
        return children;
    }

    public boolean isLexicallySorted() {
        return MSDLPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort");
    }

    public boolean isCategoricallySorted() {
        return MSDLPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort");
    }
}

