/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.lazy.outline;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ElementType;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.msdldt.model.reflection.FieldModifier;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfCovergroup;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.views.OutlineTreeViewProvider;
import ro.amiq.msdldt.model.reflection.views.RfTreeElementWrapper;

public enum MSDLOutlineUtil {
    INSTANCE;

    private static final ElementType.ElementTypeName[] parentElements;
    private static final Set<ElementType.ElementTypeName> PARENT_ELEMENTS_SET;
    private OutlineTreeViewProvider labelProvider = new OutlineTreeViewProvider();

    static {
        parentElements = new ElementType.ElementTypeName[]{ElementType.ElementTypeName.PACKAGE, ElementType.ElementTypeName.COMPONENT, ElementType.ElementTypeName.MSDL_ACTOR, ElementType.ElementTypeName.MSDL_SCENARIO, ElementType.ElementTypeName.STRUCT, ElementType.ElementTypeName.COVER_GROUP, ElementType.ElementTypeName.BLOCK, ElementType.ElementTypeName.FIELD, ElementType.ElementTypeName.CONSTRAINT};
        PARENT_ELEMENTS_SET = EnumSet.copyOf(Arrays.asList(parentElements));
    }

    public boolean isOutlineElement(IRfDefElement def) {
        FieldModifier fieldModifier;
        if (!(def instanceof RfDefElement)) {
            return false;
        }
        RfDefElement element = (RfDefElement)def;
        RfNamedElement namedElement = element.getNamedElement();
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof RfBlock) {
            return false;
        }
        if (namedElement instanceof RfField && (fieldModifier = ((RfField)namedElement).getFieldModifier()) == FieldModifier.PARAMETER) {
            return false;
        }
        if (this.isUnnamedBlock(def)) {
            return false;
        }
        return !namedElement.isAnonymous();
    }

    public boolean isUnnamedBlock(IRfDefElement def) {
        if (!(def instanceof RfDefElement)) {
            return false;
        }
        RfDefElement element = (RfDefElement)def;
        RfNamedElement namedElement = element.getNamedElement();
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof RfBlock) {
            return true;
        }
        RfProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return false;
        }
        ElementType elementType = rfProject.computeElementType(element, null, null);
        if (elementType == null) {
            return false;
        }
        if (PARENT_ELEMENTS_SET.contains(elementType.getElementTypeName()) && (!(namedElement instanceof RfField) || ((RfField)namedElement).getFieldModifier() == FieldModifier.COVERGROUP_INLINE)) {
            return !namedElement.isAnonymous() && !(namedElement instanceof RfCovergroup);
        }
        return false;
    }

    public DVTGUIFilterMatcher.GUIFilterResult getFilterResult(IRfDefElement element) {
        if (!(element instanceof RfDefElement)) {
            return null;
        }
        IRfNamedElement namedElement = element.getNamedElement();
        RfTreeElementWrapper wrapper = new RfTreeElementWrapper(element, namedElement instanceof RfField);
        DVTGUIFilterMatcher.GUIFilterResult result = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.OUTLINE, (IRfDefElement)element, () -> this.labelProvider.getText((Object)wrapper));
        return result;
    }

    public boolean isPossibleOutlineParent(IRfDefElement def) {
        if (!(def instanceof RfDefElement)) {
            return false;
        }
        RfDefElement element = (RfDefElement)def;
        RfNamedElement namedElement = element.getNamedElement();
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof RfBlock) {
            return true;
        }
        RfProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return false;
        }
        ElementType elementType = rfProject.computeElementType(element, null, null);
        if (elementType == null) {
            return false;
        }
        return PARENT_ELEMENTS_SET.contains(elementType.getElementTypeName()) && (!(namedElement instanceof RfField) || ((RfField)namedElement).getFieldModifier() == FieldModifier.COVERGROUP_INLINE);
    }
}

