/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.outline;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.msdldt.model.reflection.FieldModifier;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.views.RfTreeElementWrapper;

public class AccessLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "ro.amiq.msdldt.AccessLabelDecorator";

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof RfTreeElementWrapper) {
            this.decorateRfDefElement((RfTreeElementWrapper)((Object)element), decoration);
        }
    }

    private void decorateRfDefElement(RfTreeElementWrapper def, IDecoration decoration) {
        Object element = def.getRfElement();
        if (element instanceof RfDefElement) {
            element = ((RfDefElement)element).getNamedElement();
        }
        if (element instanceof RfField) {
            if (!def.getAccessDecoratorEnable()) {
                return;
            }
            RfNamedElement namedElement = (RfNamedElement)element;
            if (!(namedElement instanceof RfField)) {
                return;
            }
            RfField field = (RfField)namedElement;
            FieldModifier fieldModifier = field.getFieldModifier();
            if (fieldModifier == FieldModifier.COVERCROSS || fieldModifier == FieldModifier.COVERPOINT || fieldModifier == FieldModifier.COVERGROUP_PORT || fieldModifier == FieldModifier.PARAMETER || fieldModifier == FieldModifier.INDEX) {
                return;
            }
            if (namedElement.isPrivate()) {
                decoration.addOverlay(DVTImages.OVR_PRIVATE, 0);
            } else if (namedElement.isProtected()) {
                decoration.addOverlay(DVTImages.OVR_PROTECTED, 0);
            } else {
                decoration.addOverlay(DVTImages.OVR_PUBLIC, 0);
            }
        }
    }

    public void refresh(final Object[] elements) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AccessLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)AccessLabelDecorator.this, elements));
            }
        });
    }
}

