/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.outline;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfCovergroup;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfEnumItem;
import ro.amiq.msdldt.model.reflection.RfEnumType;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfMethod;
import ro.amiq.msdldt.model.reflection.RfPackage;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.RfTypeAlias;
import ro.amiq.msdldt.model.reflection.StructKind;
import ro.amiq.msdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.msdldt.ui.editor.outline.CategorySortingAction;

public class ViewCategorySortingAction
extends CategorySortingAction {
    private MSDLCategorySorter fSorter;
    private TreeViewer fTreeViewer;

    public ViewCategorySortingAction(TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
        this.fSorter = new MSDLCategorySorter();
        boolean disabled = MSDLPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort");
        this.setEnabled(!disabled);
        if (!disabled) {
            boolean checked = MSDLPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort");
            this.valueChanged(checked);
        }
    }

    @Override
    protected void valueChanged(boolean on) {
        super.valueChanged(on);
        this.fTreeViewer.setSorter((ViewerSorter)(on ? this.fSorter : null));
    }

    private static class MSDLCategorySorter
    extends ViewerSorter {
        private MSDLCategorySorter() {
        }

        public int category(Object obj) {
            if (obj instanceof RfTreeElementWrapper) {
                Object elem = ((RfTreeElementWrapper)((Object)obj)).getRfElement();
                if (elem instanceof RfDefElement) {
                    elem = ((RfDefElement)elem).getNamedElement();
                }
                if (elem instanceof RfPackage) {
                    return 0;
                }
                if (elem instanceof RfStruct && ((RfStruct)elem).getStructKind() == StructKind.ACTOR) {
                    return 1;
                }
                if (elem instanceof RfStruct && ((RfStruct)elem).getStructKind() == StructKind.SCENARIO) {
                    return 2;
                }
                if (elem instanceof RfStruct && ((RfStruct)elem).getStructKind() == StructKind.STRUCT) {
                    return 2;
                }
                if (elem instanceof RfStruct) {
                    return 3;
                }
                if (elem instanceof RfTypeAlias) {
                    return 4;
                }
                if (elem instanceof RfEnumType) {
                    return 5;
                }
                if (elem instanceof RfCovergroup) {
                    return 6;
                }
                if (elem instanceof RfField) {
                    return 7;
                }
                if (elem instanceof RfEnumItem) {
                    return 8;
                }
                if (elem instanceof RfEnumItem) {
                    return 9;
                }
                if (elem instanceof RfMethod) {
                    return 10;
                }
                if (elem instanceof RfBlock) {
                    return 11;
                }
            }
            return 100;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int line2;
            int cat2;
            if (!(((RfTreeElementWrapper)((Object)e1)).getRfElement() instanceof RfDefElement) || !(((RfTreeElementWrapper)((Object)e2)).getRfElement() instanceof RfDefElement)) {
                return 0;
            }
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            int line1 = ((RfDefElement)((RfTreeElementWrapper)((Object)e1)).getRfElement()).getStartLine();
            if (line1 == (line2 = ((RfDefElement)((RfTreeElementWrapper)((Object)e2)).getRfElement()).getStartLine())) {
                return 0;
            }
            if (line1 > line2) {
                return 1;
            }
            return -1;
        }
    }
}

