/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.msdldt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;
import ro.amiq.msdldt.ui.editor.quickfix.util.MSDLQuickFixUtil;

public class DeclareArgumentQuickFix
extends AbstractVariableQuickFix {
    private String fReplacementString;
    private int fInsertOffset;
    private IRfDefElement fDeclaration;

    public DeclareArgumentQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARGUMENT);
    }

    public String getDisplayString() {
        return "Declare argument '" + this.elementName + "'";
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.fReplacementString = null;
        this.fInsertOffset = -1;
        if (this.fDeclaration == null) {
            return;
        }
        int startOffset = this.fDeclaration.getStartOffset();
        this.fDeclaration.getEndOffset();
        int rparenOffset = MSDLQuickFixUtil.getBackwardOffsetFor(document, ")", startOffset, this.fInsertOffset, true, true);
        if (rparenOffset > 0 && rparenOffset < this.fInsertOffset) {
            this.fInsertOffset = rparenOffset;
        }
        if (this.fInsertOffset < 0) {
            return;
        }
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        if (this.fInsertOffset < 0) {
            return;
        }
        Region region = new Region(this.fInsertOffset, 0);
        TemplateContext context = this.createContext(document, (IRegion)region);
        Template template = new Template("", this.getDisplayString(), "ro.amiq.msdldt.templates.contextType.unknown", this.fReplacementString, false);
        TemplateProposal templateProposal = new TemplateProposal(template, context, (IRegion)region, this.getImage(), 1);
        templateProposal.apply(this.viewer, '\u0000', 0, this.fInsertOffset);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.fDeclaration.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

