/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;

public class DeclareSignalQuickFix
extends AbstractVariableQuickFix {
    protected IRfDefElement declaration;
    protected boolean declareInside;
    private RfNamedElement enclosingElement;
    private String fReplacementString;
    private int fInsertOffset;

    public DeclareSignalQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SIGNAL);
    }

    public String getDisplayString() {
        boolean isHierarchical = this.marker.getAttribute("QUICKFIX_HIERARCHICAL_ID", false);
        if (isHierarchical) {
            String elementPathString = this.marker.getAttribute("QUICKFIX_SCOPE_ELEMENT_PATH", null);
            RfElementPath elementPath = RfElementPath.fromString((String)elementPathString, DeclareSignalQuickFix.class);
            IRfNamedElement tempEnclosing = elementPath == null ? null : elementPath.toNamedElement(this.marker.getResource().getProject());
            this.enclosingElement = tempEnclosing instanceof RfNamedElement ? (RfNamedElement)tempEnclosing : null;
        } else {
            this.enclosingElement = this.getEnclosingScope((RfDefElement)this.enclosingScope, RfStruct.class);
        }
        return "Declare signal '" + this.elementName + "'";
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        boolean isHierarchical = this.marker.getAttribute("QUICKFIX_HIERARCHICAL_ID", false);
        if (isHierarchical) {
            String elementPathString = this.marker.getAttribute("QUICKFIX_SCOPE_ELEMENT_PATH", null);
            RfElementPath elementPath = RfElementPath.fromString((String)elementPathString, DeclareSignalQuickFix.class);
            IRfNamedElement tempEnclosing = elementPath == null ? null : elementPath.toNamedElement(this.marker.getResource().getProject());
            this.enclosingElement = tempEnclosing instanceof RfNamedElement ? (RfNamedElement)tempEnclosing : null;
        } else {
            this.enclosingElement = this.getEnclosingScope((RfDefElement)this.enclosingScope, RfStruct.class);
        }
        if (this.enclosingElement != null) {
            RfDefElement declaration = null;
            if (declaration == null) {
                Collection<RfNamedElement> members = this.enclosingElement.getLocalMembers();
                List<RfNamedElement> membersList = Collections.emptyList();
                if (members != null) {
                    membersList = new ArrayList<RfNamedElement>(members);
                }
                if (membersList != null && !membersList.isEmpty() && !membersList.get(membersList.size() - 1).isPredefined()) {
                    Collections.sort(membersList, new NamedElementsComparator());
                    for (RfNamedElement member : membersList) {
                        if (member == null || member.isPredefined() || (declaration = member.getDeclaration()) == null) continue;
                        if (declaration.getDefFile().getAdapter(IResource.class) != this.marker.getResource() || declaration.getStartOffset() <= this.offset) break;
                        declaration = null;
                    }
                }
            }
            if (declaration == null) {
                this.declareInside = true;
                declaration = this.enclosingElement.getDeclaration();
            }
            if (declaration != null && declaration.getDefFile() != null) {
                IResource resourceToApplyFix = (IResource)declaration.getDefFile().getAdapter(IResource.class);
                if (resourceToApplyFix != this.marker.getResource()) {
                    this.targetResource = resourceToApplyFix;
                }
                this.declaration = declaration;
            }
        }
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.marker.getAttribute("QUICKFIX_HIERARCHICAL_ID", false);
        this.fInsertOffset = this.declaration.getStartOffset();
        String indent = DVTDocumentUtils.getIndent((int)this.fInsertOffset, (IDocument)document);
        if (indent.isEmpty()) {
            indent = TextUtils.getIndentTab((boolean)true, (int)this.tabWidth);
        }
        IRegion lineInformationOfOffset = document.getLineInformationOfOffset(this.fInsertOffset);
        this.fReplacementString = null;
        this.fInsertOffset = !this.declareInside && !(this.declaration.getNamedElement() instanceof RfField) ? lineInformationOfOffset.getOffset() : lineInformationOfOffset.getOffset() + lineInformationOfOffset.getLength();
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        Region region = new Region(this.fInsertOffset, 0);
        TemplateContext context = this.createContext(document, (IRegion)region);
        Template template = new Template("", this.getDisplayString(), "ro.amiq.msdldt.templates.contextType.unknown", this.fReplacementString, false);
        TemplateProposal templateProposal = new TemplateProposal(template, context, (IRegion)region, this.getImage(), 1);
        templateProposal.apply(this.viewer, '\u0000', 0, this.fInsertOffset);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.declaration.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }

    static class NamedElementsComparator
    implements Comparator<RfNamedElement> {
        NamedElementsComparator() {
        }

        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            RfDefElement declaration1 = o1.getDeclaration();
            RfDefElement declaration2 = o2.getDeclaration();
            if (declaration1 == null || declaration2 == null) {
                return 0;
            }
            return declaration2.getStartOffset() - declaration1.getStartOffset();
        }
    }
}

