/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.msdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.msdldt.ui.editor.quickfix.util.MSDLQuickFixUtil;

public class DeprecatedPkgRemoveQuickFix
extends BaseAbstractQuickFix {
    public DeprecatedPkgRemoveQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Remove deprecated package '" + this.elementName + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        int startOffset = MSDLQuickFixUtil.getBackwardOffsetFor(document, "use", Math.max(0, this.offset - 200), this.offset, true, true);
        if (startOffset < 0) {
            return;
        }
        int maxOffsetLimit = startOffset + 1000;
        int endOffset = MSDLQuickFixUtil.getForwardOffsetFor(document, ";", this.offset, maxOffsetLimit, true);
        if (endOffset < 0) {
            return;
        }
        document.replace(startOffset, endOffset - startOffset, "");
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

