/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.msdldt.ui.refactor.MSDLTextFileChange;

public class DidYouMeanQuickFix
extends BaseAbstractQuickFix {
    private RfFileDef fTargetFile;
    private String fProposalName;
    private Image fTypeImage;

    public DidYouMeanQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public DidYouMeanQuickFix(IMarker marker, ITextViewer viewer, String proposalName, Image typeImage, RfFileDef file) {
        super(marker, viewer);
        this.fTypeImage = typeImage;
        this.fTargetFile = file;
        this.fProposalName = proposalName;
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.textFileChange = new MSDLTextFileChange(this.fTargetFile.getName(), (IFile)this.fTargetFile.getFileAdapter());
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        this.textFileChange.addEdit((TextEdit)new ReplaceEdit(this.position.getOffset(), this.position.getLength(), this.fProposalName));
    }

    public IFile[] getAffectedFiles() throws Exception {
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        Object[] objectArray = this.textFileChange.getAffectedObjects();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IFile) {
                affectedFiles.add((IFile)o);
            }
            ++n2;
        }
        return affectedFiles.toArray(new IFile[affectedFiles.size()]);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        try {
            DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, this.targetDocument, this.getDisplayString(), (Change)this.textFileChange);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getDisplayString() {
        return "Did you mean '" + this.fProposalName + "'?";
    }

    public Image getImage() {
        return this.fTypeImage;
    }
}

