/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.ui.editor.quickassist.util.MSDLQuickAssistUtil;
import ro.amiq.msdldt.ui.editor.quickfix.quickfixes.BaseImportOrFullyQualifyQuickFix;
import ro.amiq.msdldt.ui.refactor.MSDLTextFileChange;

public class ImportQuickFix
extends BaseImportOrFullyQualifyQuickFix {
    private static final String NEW_LINE = System.lineSeparator();
    private String USE = "use ";
    private String LIBRARY = "library ";
    private String ALL = "all";
    private RfDefElement fElementToImportAbove;
    private RfNamedElement fTypeToImport;
    private String fLibraryName;
    private String fTypeName;
    private LinkedModeModel fLinkedProposalModel;
    private DVTLinkedPositionProvider fLinkedPositionMaker;
    private MSDLTextFileChange fTextFileChange;
    private Position fOriginalCursorPosition;
    private DVTEditor fTriggerEditor;
    private DVTEditor fTargetEditor;
    private IDocument fTargetDocument;
    private int fCapsPreferenceKeywords;
    private int fCapsPreferenceDataTypes;
    private RfFileDef fElementDeclarationFileDef;
    private IResource fFileDefAdapter;

    public ImportQuickFix(IMarker marker, ITextViewer viewer, RfNamedElement typeToImport, RfDefElement elementToImportAbove, String importString, String libraryName) {
        super(marker, viewer, importString);
        this.fTypeToImport = typeToImport;
        this.fTypeName = this.fTypeToImport.getName();
        this.fElementToImportAbove = elementToImportAbove;
        this.fLibraryName = libraryName;
        this.fCapsPreferenceKeywords = MSDLPlugin.getDefault().getPreferenceStore().getInt("format.capitalization.keywords");
        this.fCapsPreferenceDataTypes = MSDLPlugin.getDefault().getPreferenceStore().getInt("format.capitalization.data_types");
        if (this.fCapsPreferenceKeywords == 2) {
            this.LIBRARY = this.LIBRARY.toUpperCase();
            this.USE = this.USE.toUpperCase();
            this.ALL = this.ALL.toUpperCase();
        }
        if (this.fCapsPreferenceDataTypes == 2) {
            this.fTypeName = this.fTypeName.toUpperCase();
        } else if (this.fCapsPreferenceDataTypes == 3) {
            this.fTypeName = this.fTypeName.toLowerCase();
        }
        this.fLinkedProposalModel = new LinkedModeModel();
    }

    public String getDisplayString() {
        return "Add '" + this.USE + this.fImportName + this.ALL + "' to import '" + this.fTypeName + "' type";
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        this.fTriggerEditor = (DVTEditor)DVTUiUtils.getActivePage().getActiveEditor();
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        this.performChanges();
        try {
            this.addLinkedPositions(editorChanged);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean createChanges() throws BadLocationException {
        int insertOffset = -1;
        new StringBuilder();
        if (insertOffset < 0) {
            return false;
        }
        this.fTextFileChange = new MSDLTextFileChange(this.fElementDeclarationFileDef.getName(), (IFile)this.fFileDefAdapter);
        this.fTextFileChange.setEdit((TextEdit)new MultiTextEdit());
        return true;
    }

    private void performChanges() {
        try {
            this.fOriginalCursorPosition = new DVTPosition(this.offset);
            this.fTriggerEditor.getDocument().addPosition(this.fOriginalCursorPosition);
            DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.fTargetEditor, this.fTargetDocument, this.getDisplayString(), (Change)this.fTextFileChange);
        }
        catch (CoreException | BadLocationException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private void addLinkedPositions(boolean editorChanged) throws Exception {
        Collection absoluteRegions = this.fTextFileChange.getAbsoluteRegions();
        if (absoluteRegions.isEmpty()) {
            return;
        }
        IRegion region = (IRegion)absoluteRegions.iterator().next();
        this.fLinkedPositionMaker.addSingleLinkedPosition(region.getOffset(), region.getLength(), this.fTargetDocument);
        DVTExitPolicyConfig config = new DVTExitPolicyConfig(true, this.triggerEditor.getCursor(), "__msdl_partitioning");
        this.fLinkedPositionMaker.enterLinkedMode(this.fTargetDocument, config);
    }

    private String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.fElementDeclarationFileDef = this.fElementToImportAbove.getDefFile();
        this.fFileDefAdapter = this.fElementDeclarationFileDef.getFileAdapter();
        if (this.fFileDefAdapter == null || !(this.fFileDefAdapter instanceof IFile)) {
            return;
        }
        this.fTargetEditor = (DVTEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)this.fFileDefAdapter));
        if (this.fTargetEditor == null) {
            return;
        }
        this.fTargetDocument = this.fTargetEditor.getDocument();
        if (this.fTargetDocument == null) {
            return;
        }
        this.fLinkedPositionMaker = new DVTLinkedPositionProvider(this.fTriggerEditor, this.fTargetEditor, this.fLinkedProposalModel, this.getCategory(), true, true);
        if (!this.createChanges()) {
            MSDLQuickAssistUtil.popSomethingWentWrong((String)this.getDisplayString());
            return;
        }
    }

    public IFile[] getAffectedFiles() throws Exception {
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        Object[] objectArray = this.fTextFileChange.getAffectedObjects();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IFile) {
                affectedFiles.add((IFile)o);
            }
            ++n2;
        }
        return affectedFiles.toArray(new IFile[affectedFiles.size()]);
    }
}

