/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.msdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.msdldt.ui.editor.quickfix.util.MSDLQuickFixUtil;

public class LibraryClauseRemoveQuickFix
extends BaseAbstractQuickFix {
    public LibraryClauseRemoveQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Remove clause library '" + this.elementName + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_LIBRARY);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        int libraryNameStartOffset = this.position.getOffset();
        int libraryNameEndOffset = this.position.getOffset() + this.position.getLength();
        int libraryKeywordOffset = MSDLQuickFixUtil.getBackwardOffsetFor(document, "library", Math.max(0, libraryNameStartOffset - 200), libraryNameStartOffset, false, false);
        int semicolonOffset = MSDLQuickFixUtil.getForwardOffsetFor(document, ";", libraryNameStartOffset, libraryNameStartOffset + 100, true);
        if (libraryKeywordOffset < 0 || semicolonOffset < 0) {
            return;
        }
        int removeStartOffset = libraryKeywordOffset;
        int removeEndOffset = semicolonOffset;
        int leftCommaOffset = MSDLQuickFixUtil.getBackwardOffsetFor(document, ",", libraryKeywordOffset, libraryNameStartOffset, false, false);
        int rightCommaOffset = MSDLQuickFixUtil.getForwardOffsetFor(document, ",", libraryNameEndOffset, semicolonOffset, false);
        if (leftCommaOffset > libraryKeywordOffset && leftCommaOffset <= libraryNameStartOffset) {
            if (rightCommaOffset >= libraryNameEndOffset && rightCommaOffset < semicolonOffset) {
                document.replace(leftCommaOffset, rightCommaOffset - leftCommaOffset, ",");
                return;
            }
            document.replace(leftCommaOffset, libraryNameEndOffset - leftCommaOffset, "");
            return;
        }
        if (rightCommaOffset >= libraryNameEndOffset && rightCommaOffset < semicolonOffset) {
            document.replace(libraryNameStartOffset, rightCommaOffset - libraryNameStartOffset, "");
            return;
        }
        document.replace(removeStartOffset, removeEndOffset - removeStartOffset, "");
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

