/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.msdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.msdldt.ui.editor.quickfix.util.MSDLQuickFixUtil;

public class SensitivityRemoveQuickFix
extends BaseAbstractQuickFix {
    private int fStartOffset;
    private int fEndOffset;

    public SensitivityRemoveQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Remove signal '" + this.elementName + "' from sensitivity list";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROCESS);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.fStartOffset = this.position.getOffset();
        this.fEndOffset = this.fStartOffset + this.position.getLength();
        boolean lastItem = false;
        int maxOffsetLimit = this.fEndOffset + 1000;
        int rParenOffset = Math.max(this.fEndOffset, MSDLQuickFixUtil.getForwardOffsetFor(document, ")", this.fEndOffset, maxOffsetLimit, false));
        int rCommaOffset = Math.min(rParenOffset, MSDLQuickFixUtil.getForwardOffsetFor(document, ",", this.fEndOffset, rParenOffset, true));
        if (this.fEndOffset < rParenOffset && rParenOffset == rCommaOffset) {
            lastItem = true;
        } else {
            this.fEndOffset = Math.min(rParenOffset, rCommaOffset);
            if (this.fEndOffset == rParenOffset) {
                --this.fEndOffset;
            }
        }
        int lParenOffset = Math.min(this.fStartOffset, MSDLQuickFixUtil.getBackwardOffsetFor(document, "(", 0, this.fStartOffset, false));
        int lCommaOffset = Math.max(lParenOffset, MSDLQuickFixUtil.getBackwardOffsetFor(document, ",", lParenOffset, this.fStartOffset, true));
        if (lastItem) {
            this.fStartOffset = lCommaOffset;
            if (this.fStartOffset == lParenOffset) {
                ++this.fStartOffset;
            }
        } else if (this.fStartOffset > lParenOffset) {
            // empty if block
        }
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        document.replace(this.fStartOffset, this.fEndOffset - this.fStartOffset, "");
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

