/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.rules;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.editor.highlight.IHighlightListener;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightPosition;
import ro.amiq.msdldt.ui.editor.MSDLCodeScanner;
import ro.amiq.msdldt.ui.editor.MSDLStyle;
import ro.amiq.msdldt.ui.preferences.PrefConst;

public class MSDLKeyWordRule
implements IRule,
IHighlightListener {
    private static final Comparator<Position> POSITION_COMPARATOR = new Comparator<Position>(){

        @Override
        public int compare(Position o1, Position o2) {
            return o1.getOffset() - o2.getOffset();
        }
    };
    private IToken fDefaultPhrasesToken;
    private IToken fDefaultUnitToken;
    private IToken fDefaultKeyWordToken;
    private String[][] fPhrases;
    private Set<String> fTypeKeyWords;
    private Set<String> fUnitKeyWords;
    private Set<String> fHighlightKeyWords;
    private Position[] fPositions;
    private IDocument fDocument;
    private int fMaxPhraseLength;
    private IToken fDefaultEnumItemToken;
    private IToken fDefaultActorToken;
    private IToken fDefaultScenarioToken;
    private IToken fDefaultScenarioDeclToken;
    private IToken fDefaultModifierToken;
    private IToken fDefaultModifierDeclToken;
    private IToken fDefaultMethodToken;
    private IToken fDefaultTemplateToken;
    private IToken fDefaultWordToken;
    private IToken fDefaultArgumentToken;
    private IToken fDefaultTypeToken;
    private IToken fDefaultFieldToken;
    private IToken fDefaultEventToken;
    private IToken fDefaultLabelToken;
    private MSDLStyle fStyle;
    private static final Pattern fUnderscoreTemplatePattern = Pattern.compile("__[a-zA-Z$][a-zA-Z0-9$_]*?__");
    private static final Pattern fx_ID_xTemplatePattern = Pattern.compile("x_[a-zA-Z$][a-zA-Z0-9$_]*?_x");

    public MSDLKeyWordRule(MSDLStyle style) {
        String[][] phrases = PrefConst.getMSDLKeyphrasesForHighlight();
        IToken defaultPhrasesToken = style.getToken("highlight.keyphrase");
        Assert.isNotNull((Object)defaultPhrasesToken);
        Assert.isNotNull((Object)phrases);
        Assert.isTrue((phrases.length > 1 ? 1 : 0) != 0);
        this.fPhrases = phrases;
        this.fDefaultPhrasesToken = defaultPhrasesToken;
        this.fMaxPhraseLength = 0;
        int i = 0;
        while (i < this.fPhrases.length) {
            this.fMaxPhraseLength = Math.max(this.fMaxPhraseLength, this.fPhrases[i].length);
            ++i;
        }
        this.fTypeKeyWords = new HashSet<String>(Arrays.asList(PrefConst.getMSDLTypes()));
        this.fUnitKeyWords = new HashSet<String>(Arrays.asList(PrefConst.getMSDLUnits()));
        this.fHighlightKeyWords = new HashSet<String>(Arrays.asList(PrefConst.getMSDLKeywords()));
        this.fDefaultUnitToken = style.getToken("highlight.units");
        this.fDefaultKeyWordToken = style.getToken("highlight.keyword");
        this.fDefaultEnumItemToken = style.getToken("highlight.semantic_enum_item");
        this.fDefaultActorToken = style.getToken("highlight.semantic_actor");
        this.fDefaultScenarioToken = style.getToken("highlight.semantic_scenario");
        this.fDefaultModifierToken = style.getToken("highlight.semantic_modifier");
        this.fDefaultScenarioDeclToken = style.getToken("highlight.semantic_scenario_decl");
        this.fDefaultModifierDeclToken = style.getToken("highlight.semantic_modifier_decl");
        this.fDefaultMethodToken = style.getToken("highlight.semantic_method");
        this.fDefaultTemplateToken = style.getToken("highlight.template_id");
        this.fDefaultWordToken = style.getToken("highlight.default");
        this.fDefaultArgumentToken = style.getToken("highlight.semantic_argument");
        this.fDefaultTypeToken = style.getToken("highlight.types");
        this.fDefaultFieldToken = style.getToken("highlight.semantic_field");
        this.fDefaultLabelToken = style.getToken("highlight.semantic_label");
        this.fDefaultEventToken = style.getToken("highlight.event");
        this.fStyle = style;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        Matcher matcher;
        Matcher matcher2;
        TestHelper.getInstance().setLastTokenTime();
        char c = (char)scanner.read();
        int length = 1;
        boolean isTemplateIdentifierEnabled = this.fStyle.isTemplateIdentifierHighlightEnabled();
        boolean isXTemplateIdentifierEnabled = this.fStyle.isXTemplateIdentifierHighlightEnabled();
        if (!Character.isJavaIdentifierStart(c)) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        StringLengthPair[] sbs = new StringLengthPair[this.fMaxPhraseLength];
        int[] trailingWhitespaces = new int[this.fMaxPhraseLength];
        int nofWords = 0;
        int nofUnderscores = 0;
        int x_ID_xIdentifierMatches = 0;
        nofWords = 0;
        while (nofWords < this.fMaxPhraseLength) {
            if (!Character.isJavaIdentifierStart(c) && c != '~') break;
            sbs[nofWords] = new StringLengthPair();
            char p = '\u0000';
            do {
                if (isTemplateIdentifierEnabled && c == '_' && (char)p == '_') {
                    sbs[nofWords].nofUnderscores += 2;
                }
                if (isXTemplateIdentifierEnabled) {
                    if (c == '_' && (char)p == 'x') {
                        sbs[nofWords].x_ID_xIdentifierMatches += 2;
                    }
                    if (c == 'x' && (char)p == '_') {
                        sbs[nofWords].x_ID_xIdentifierMatches += 2;
                    }
                }
                sbs[nofWords].sb.append(c);
                ++sbs[nofWords].len;
                ++length;
                p = c;
            } while ((c = (char)scanner.read()) != '\uffff' && (Character.isJavaIdentifierPart(c) || c == '~'));
            if (nofWords == this.fMaxPhraseLength - 1) {
                ++nofWords;
                break;
            }
            if (Character.isWhitespace(c)) {
                do {
                    ++sbs[nofWords].len;
                    int n = nofWords;
                    trailingWhitespaces[n] = trailingWhitespaces[n] + 1;
                    ++length;
                } while (Character.isWhitespace(c = (char)scanner.read()));
            }
            ++nofWords;
        }
        --length;
        scanner.unread();
        if (nofWords > 1) {
            int keyLength = 0;
            int i = 0;
            while (i < this.fPhrases.length) {
                boolean nextPhrase = false;
                String[] phrase = this.fPhrases[i];
                if (phrase.length <= nofWords) {
                    int j = 0;
                    while (j < phrase.length) {
                        StringLengthPair candidate = sbs[j];
                        if (!phrase[j].equals(candidate.sb.toString())) {
                            keyLength = 0;
                            nextPhrase = true;
                            break;
                        }
                        keyLength += candidate.len;
                        ++j;
                    }
                    if (!nextPhrase) {
                        ((DVTBaseScanner)scanner).unreadLength(length - (keyLength -= sbs[phrase.length - 1].len - sbs[phrase.length - 1].sb.length()));
                        return this.fDefaultPhrasesToken;
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < trailingWhitespaces[0]) {
            --length;
            scanner.unread();
            --sbs[0].len;
            ++i;
        }
        String candidate = sbs[0].sb.toString();
        nofUnderscores = sbs[0].nofUnderscores;
        x_ID_xIdentifierMatches = sbs[0].x_ID_xIdentifierMatches;
        if (nofUnderscores >= 4 && (matcher2 = fUnderscoreTemplatePattern.matcher(candidate)).find()) {
            if (matcher2.start() == 0) {
                ((DVTBaseScanner)scanner).unreadLength(length - matcher2.end());
                return this.fDefaultTemplateToken;
            }
            ((DVTBaseScanner)scanner).unreadLength(length - matcher2.start());
            if (c == '(') {
                return this.fDefaultMethodToken;
            }
            return this.fDefaultWordToken;
        }
        if (x_ID_xIdentifierMatches >= 4 && (matcher = fx_ID_xTemplatePattern.matcher(candidate)).find()) {
            if (matcher.start() == 0) {
                ((DVTBaseScanner)scanner).unreadLength(length - matcher.end());
                return this.fDefaultTemplateToken;
            }
            ((DVTBaseScanner)scanner).unreadLength(length - matcher.start());
            if (c == '(') {
                return this.fDefaultMethodToken;
            }
            return this.fDefaultWordToken;
        }
        boolean isSemanticHighlightEnabled = this.fStyle.isSemanticHighlightEnabled();
        if (isSemanticHighlightEnabled) {
            this.fDocument = ((MSDLCodeScanner)scanner).getDocument();
            int startOffset = ((MSDLCodeScanner)scanner).getOffset() - length;
            SemanticHighlightPosition highlightPosition = (SemanticHighlightPosition)this.getPosition(startOffset);
            if (highlightPosition != null) {
                HighlightKind highlighKind = highlightPosition.getHighlightKind();
                IToken returnHighlightKindToken = null;
                if (highlighKind == HighlightKind.MSDL_ENUM_ITEM) {
                    returnHighlightKindToken = this.fDefaultEnumItemToken;
                } else if (highlighKind == HighlightKind.MSDL_ACTOR) {
                    returnHighlightKindToken = this.fDefaultActorToken;
                } else if (highlighKind == HighlightKind.MSDL_SCENARIO_DECL) {
                    returnHighlightKindToken = this.fDefaultScenarioDeclToken;
                } else if (highlighKind == HighlightKind.MSDL_SCENARIO) {
                    returnHighlightKindToken = this.fDefaultScenarioToken;
                } else if (highlighKind == HighlightKind.MSDL_MODIFIER_DECL) {
                    returnHighlightKindToken = this.fDefaultModifierDeclToken;
                } else if (highlighKind == HighlightKind.MSDL_MODIFIER) {
                    returnHighlightKindToken = this.fDefaultModifierToken;
                } else if (highlighKind == HighlightKind.ARGUMENT) {
                    returnHighlightKindToken = this.fDefaultArgumentToken;
                } else if (highlighKind == HighlightKind.TYPE) {
                    returnHighlightKindToken = this.fDefaultTypeToken;
                } else if (highlighKind == HighlightKind.FIELD) {
                    returnHighlightKindToken = this.fDefaultFieldToken;
                } else if (highlighKind == HighlightKind.METHOD) {
                    returnHighlightKindToken = this.fDefaultMethodToken;
                } else if (highlighKind == HighlightKind.EVENT) {
                    returnHighlightKindToken = this.fDefaultEventToken;
                } else if (highlighKind == HighlightKind.LABEL) {
                    returnHighlightKindToken = this.fDefaultLabelToken;
                }
                if (returnHighlightKindToken != null) {
                    ((DVTBaseScanner)scanner).unreadLength(length - sbs[0].len);
                    return returnHighlightKindToken;
                }
            }
        }
        if (this.checkCandidate(this.fHighlightKeyWords, candidate)) {
            ((DVTBaseScanner)scanner).unreadLength(length - sbs[0].len);
            return this.fDefaultKeyWordToken;
        }
        if (this.checkCandidate(this.fTypeKeyWords, candidate)) {
            ((DVTBaseScanner)scanner).unreadLength(length - sbs[0].len);
            return this.fDefaultTypeToken;
        }
        if (this.checkCandidate(this.fUnitKeyWords, candidate)) {
            ((DVTBaseScanner)scanner).unreadLength(length - sbs[0].len);
            return this.fDefaultUnitToken;
        }
        if (nofWords == 1 && c == '(') {
            return this.fDefaultMethodToken;
        }
        if (nofWords == 1) {
            return this.fDefaultWordToken;
        }
        ((DVTBaseScanner)scanner).unreadLength(length - sbs[0].len);
        return this.fDefaultWordToken;
    }

    private boolean checkCandidate(Set<String> keywords, String candidate) {
        return keywords.contains(candidate);
    }

    public void updateSHPositions(IDocument document, IRfFileDef file) {
        try {
            if (this.fDocument == null || !this.fDocument.equals(document)) {
                return;
            }
            if (!this.fDocument.containsPositionCategory("SEMANTIC_HIGHLIGHT")) {
                return;
            }
            this.fPositions = this.fDocument.getPositions("SEMANTIC_HIGHLIGHT");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void updateKeywords() {
        this.fHighlightKeyWords = new HashSet<String>(Arrays.asList(PrefConst.getMSDLKeywords()));
        this.fPhrases = PrefConst.getMSDLKeyphrasesForHighlight();
    }

    private Position getPosition(int offset) {
        if (this.fPositions == null) {
            return null;
        }
        int index = Arrays.binarySearch(this.fPositions, new DVTPosition(offset), POSITION_COMPARATOR);
        if (index >= 0) {
            return this.fPositions[index];
        }
        return null;
    }

    static class StringLengthPair {
        StringBuilder sb = new StringBuilder();
        int len = 0;
        int nofUnderscores = 0;
        int x_ID_xIdentifierMatches = 0;
    }
}

