/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;

public class MSDLNumericRule
implements IRule {
    private IToken fDefaultToken;
    private int fLength = 0;

    public MSDLNumericRule(IToken token) {
        Assert.isNotNull((Object)token);
        this.fDefaultToken = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        boolean isHexNumber;
        char c = (char)scanner.read();
        int length = 1;
        boolean bl = isHexNumber = c == '0';
        if (!Character.isDigit(c)) {
            ((DVTBaseScanner)scanner).unreadLength(length);
            return Token.UNDEFINED;
        }
        c = (char)scanner.read();
        ++length;
        if (!(isHexNumber &= c == 'x' || c == 'X') && !Character.isDigit(c)) {
            scanner.unread();
            return this.fDefaultToken;
        }
        c = (char)scanner.read();
        ++length;
        while (Character.isDigit(c) || isHexNumber && (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
            c = (char)scanner.read();
            ++length;
        }
        if (length > 2) {
            scanner.unread();
            return this.fDefaultToken;
        }
        ((DVTBaseScanner)scanner).unreadLength(length);
        return Token.UNDEFINED;
    }
}

