/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.editor.spelling.SpellCheckEngine;
import ro.amiq.dvt.ui.editor.spelling.TaskTagDictionary;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellDictionary;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.ui.preferences.PrefConst;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = MSDLPlugin.getDefault().getPreferenceStore();
        this.initializeMarkOccurences(store);
        this.initializeSyntaxPreferences(store);
        this.initializeOutlinePreferences(store);
        this.initializeContentAssistPreferences(store);
        this.initializeTypingPreferences(store);
        this.initializeAutoindentPreferences(store);
        this.initializeLanguageElements();
        this.initializeEditorPreferences(store);
    }

    private void initializeMarkOccurences(IPreferenceStore store) {
        store.setDefault("markOccurrences", true);
    }

    void initializeSyntaxPreferences(IPreferenceStore store) {
        store.setDefault("highlight.semantic.value", true);
        store.setDefault("highlight.template_id.value", true);
        store.setDefault("highlight.x_template_id.value", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.default.color", (RGB)PrefConst.DEFAULT_COLOR);
        store.setDefault("highlight.default.bold", false);
        store.setDefault("highlight.default.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment.color", (RGB)PrefConst.COMMENT_COLOR);
        store.setDefault("highlight.comment.bold", false);
        store.setDefault("highlight.comment.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_hyperlink.color", (RGB)PrefConst.COMMENT_HYPERLINK_COLOR);
        store.setDefault("highlight.comment_hyperlink.bold", false);
        store.setDefault("highlight.comment_hyperlink.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_pragma.color", (RGB)PrefConst.COMMENT_PRAGMA_COLOR);
        store.setDefault("highlight.comment_pragma.bold", true);
        store.setDefault("highlight.comment_pragma.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_task.color", (RGB)PrefConst.COMMENT_TASK_COLOR);
        store.setDefault("highlight.comment_task.bold", true);
        store.setDefault("highlight.comment_task.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.event.color", (RGB)PrefConst.EVENT_COLOR);
        store.setDefault("highlight.event.bold", false);
        store.setDefault("highlight.event.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.javadoc_tags.color", (RGB)PrefConst.JAVADOC_TAGS_COLOR);
        store.setDefault("highlight.javadoc_tags.bold", true);
        store.setDefault("highlight.javadoc_tags.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.keyphrase.color", (RGB)PrefConst.KEYPHRASE_COLOR);
        store.setDefault("highlight.keyphrase.bold", true);
        store.setDefault("highlight.keyphrase.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.keyword.color", (RGB)PrefConst.KEYWORD_COLOR);
        store.setDefault("highlight.keyword.bold", true);
        store.setDefault("highlight.keyword.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.number.color", (RGB)PrefConst.NUMBER_COLOR);
        store.setDefault("highlight.number.bold", false);
        store.setDefault("highlight.number.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.template_id.color", (RGB)PrefConst.PREFIX_COLOR);
        store.setDefault("highlight.template_id.bold", false);
        store.setDefault("highlight.template_id.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_actor.color", (RGB)PrefConst.SEMANTIC_ACTOR_COLOR);
        store.setDefault("highlight.semantic_actor.bold", true);
        store.setDefault("highlight.semantic_actor.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_argument.color", (RGB)PrefConst.SEMANTIC_ARGUMENT_COLOR);
        store.setDefault("highlight.semantic_argument.bold", false);
        store.setDefault("highlight.semantic_argument.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_enum_item.color", (RGB)PrefConst.SEMANTIC_ENUM_ITEM_COLOR);
        store.setDefault("highlight.semantic_enum_item.bold", true);
        store.setDefault("highlight.semantic_enum_item.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_field.color", (RGB)PrefConst.SEMANTIC_FIELD_COLOR);
        store.setDefault("highlight.semantic_field.bold", false);
        store.setDefault("highlight.semantic_field.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_label.color", (RGB)PrefConst.SEMANTIC_LABEL_COLOR);
        store.setDefault("highlight.semantic_label.bold", true);
        store.setDefault("highlight.semantic_label.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_method.color", (RGB)PrefConst.SEMANTIC_METHOD_COLOR);
        store.setDefault("highlight.semantic_method.bold", false);
        store.setDefault("highlight.semantic_method.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_modifier.color", (RGB)PrefConst.SEMANTIC_MODIFIER_COLOR);
        store.setDefault("highlight.semantic_modifier.bold", true);
        store.setDefault("highlight.semantic_modifier.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_scenario.color", (RGB)PrefConst.SEMANTIC_SCENARIO_COLOR);
        store.setDefault("highlight.semantic_scenario.bold", true);
        store.setDefault("highlight.semantic_scenario.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_modifier_decl.color", (RGB)PrefConst.SEMANTIC_MODIFIER_DECL_COLOR);
        store.setDefault("highlight.semantic_modifier_decl.bold", true);
        store.setDefault("highlight.semantic_modifier_decl.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_scenario_decl.color", (RGB)PrefConst.SEMANTIC_SCENARIO_DECL_COLOR);
        store.setDefault("highlight.semantic_scenario_decl.bold", true);
        store.setDefault("highlight.semantic_scenario_decl.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.string.color", (RGB)PrefConst.STRING_COLOR);
        store.setDefault("highlight.string.bold", false);
        store.setDefault("highlight.string.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.types.color", (RGB)PrefConst.TYPES_COLOR);
        store.setDefault("highlight.types.bold", true);
        store.setDefault("highlight.types.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.units.color", (RGB)PrefConst.UNITS_COLOR);
        store.setDefault("highlight.units.bold", true);
        store.setDefault("highlight.units.italic", false);
    }

    void initializeLanguageElements() {
        IPreferenceStore store = MSDLPlugin.getDefault().getPreferenceStore();
        store.setDefault("msdl.language.keywords", "actor;and;any;call;cover;def;default;do;else;emit;empty;event;extend;external;false;first_of;for;if;import;in;is;keep;like;match;mix;modifier;multi_match;not;null;of;on;one_of;or;pass;parallel;repeat;sample;scenario;serial;soft;struct;true;try;type;undefined;until;wait;when;with;$e_code;$end;set;");
        store.setDefault("msdl.language.keyphrases", "is also;is first;is only;list of");
        store.setDefault("msdl.language.types", "bool;int;int64;uint;uint64;real;string;acceleration;angle;angular_speed;distance;speed;temperature;time;weight");
        store.setDefault("msdl.language.units", "nm_per_ms_cubed;mpspsps;meter_per_sec_cubed;mile_per_sec_cubed;kphps;mpsps;meter_per_sec_sqr;mile_per_hour_per_sec;deg;degree;rad;radian;degree_per_second;radian_per_second;mm;millimeter;cm;centimeter;in;inch;feet;m;meter;km;kilometer;mile;kph;kilometer_per_hour;mph;mile_per_hour;meter_per_second;mps;c;celsius;f;fahrenheit;ms;millisecond;s;sec;second;min;minute;hr;hour;kg;kilogram;ton");
    }

    void initializeOutlinePreferences(IPreferenceStore store) {
        store.setDefault("outline.prefs_changed", false);
        store.setDefault("outline.show_packages", true);
        store.setDefault("outline.show_components", true);
        store.setDefault("outline.show_structs", true);
        store.setDefault("outline.show_actions", true);
        store.setDefault("outline.show_covergroups", true);
        store.setDefault("outline.show_types", true);
        store.setDefault("outline.show_activities", true);
        store.setDefault("outline.show_functions", true);
        store.setDefault("outline.show_exec_blocks", true);
        store.setDefault("outline.show_constraints", true);
        store.setDefault("outline.show_blocks", true);
        store.setDefault("outline.show_fields", true);
        DVTPredefinedGUIFilters.putOutlinePredefinedGUIFilter((LanguageKind)LanguageKind.MSDL, (IPreferenceStore)store);
    }

    void initializeContentAssistPreferences(IPreferenceStore store) {
        store.setDefault("ca.ignore_case", true);
        store.setDefault("ca.camel_case", true);
        store.setDefault("ca.prefix_match", true);
        store.setDefault("ca.chars_trigger", ".,= ,::");
        store.setDefault("ca.auto_insert_single", false);
        store.setDefault("contentAssist.autoRange.preservePortOrderAndComments", true);
        store.setDefault("contentAssist.module_autoinstance_prefix", "u_");
        store.setDefault("contentAssist.generateSignals", true);
    }

    void initializeTypingPreferences(IPreferenceStore store) {
        store.setDefault("typing.quote_case", true);
        store.setDefault("typing.paran_case", true);
        store.setDefault("typing.brack_case", true);
        store.setDefault("typing.curly_case", true);
        store.setDefault("typing.comments_case", true);
        store.setDefault("typing.enclose.brack_case", true);
        store.setDefault("typing.enclose.curly_case", true);
        store.setDefault("typing.enclose.paran_case", true);
        store.setDefault("typing.enclose.quote_case", true);
        store.setDefault("typing.transform_dot_dot_to_assign", false);
        store.setDefault("typing.transform_comma_comma_to_assign", false);
        store.setDefault("typing.transform_semicolon_to_assign", false);
        store.setDefault("typing.transform_whitespace", false);
    }

    void initializeAutoindentPreferences(IPreferenceStore store) {
        store.setDefault("autoindent.disabled", false);
    }

    void initializeEditorPreferences(IPreferenceStore store) {
        SpellCheckEngine.getInstance().registerDictionary((ISpellDictionary)new TaskTagDictionary(store));
        store.setDefault("editor.disable_tool_tips", false);
        store.setDefault("disable.compareviewer", 100000);
        PreferenceConverter.setDefault((IPreferenceStore)EditorsUI.getPreferenceStore(), (String)"matchingBracketsMSDLColor", (RGB)PrefConst.MATCHING_BRACKETS_HIGHLIGHT_COLOR_VAL);
        EditorsUI.getPreferenceStore().setDefault("matchingBracketsMSDLEnable", true);
        store.setDefault("editor.codeFolding", true);
        store.setDefault("editor.manualCodeFolding", true);
        store.setDefault("editor.numberOfLines", 10000);
        store.setDefault("inactiveCodeHighlightEnable", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"inactiveCodeHighlightColor", (RGB)PrefConst.INACTIVE_CODE_HIGHLIGHT_COLOR_VAL);
        store.setDefault("format.capitalization.keywords", 1);
        store.setDefault("format.capitalization.data_types", 1);
        store.setDefault("format.capitalization.attributes", 1);
        store.setDefault("format.whitespace.trim_end_of_line", true);
        store.setDefault("format.whitespace.trim_whitespace_line", true);
        store.setDefault("format.whitespace.compact", false);
        store.setDefault("format.whitespace.compact_consecutive_empty_lines", false);
        store.setDefault("format.whitespace.maximum_nof_consecutive_empty_lines", 1);
        store.setDefault("format.whitespace.add_after", "");
        store.setDefault("format.whitespace.add_before", "");
        store.setDefault("format.indent.begin", 1);
        store.setDefault("format.indent.else", 1);
        store.setDefault("format.indent.params", 1);
        store.setDefault("format.indent.preproc", 1);
        store.setDefault("format.indent.preserve_sl_comment_column_zero", true);
        store.setDefault("format.indent.multiline_comments", true);
        store.setDefault("format.indent.no_indent_keywords", "");
        store.setDefault("format.indent.ignore_lines", "");
        store.setDefault("format.line_wrap", false);
        store.setDefault("format.line_wrap.threshold", 80);
        store.setDefault("format.line_wrap.sl_comments", false);
        store.setDefault("format.line_wrap.ml_comments", false);
        store.setDefault("format.vertical_align", false);
        store.setDefault("format.vertical_align.sl_comments", false);
        store.setDefault("format.vertical_align.paren", false);
        store.setDefault("format.vertical_align.curly", false);
        store.setDefault("format.vertical_align.vregex", "");
        store.setDefault("format.indent.no_indent_keywords", "");
        store.setDefault("format.pre_external", false);
        store.setDefault("format.pre_external.command", "pre_format_code %f");
        store.setDefault("format.post_external", false);
        store.setDefault("format.post_external.command", "post_format_code %f");
        store.setDefault("format.external", false);
        store.setDefault("format.external.command", "format_code %f");
        store.setDefault("format.preview.show_invisible_characters", false);
        store.setDefault("format.preview.line_wrap_threshold", 50);
        store.setDefault("format.format_on_paste", "Disabled");
    }
}

