/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.search;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.msdldt.ui.search.ReferenceSearchVisitor;
import ro.amiq.msdldt.ui.search.TextSearchVisitor;
import ro.amiq.msdldt.ui.search.TypeSearchVisitor;
import ro.amiq.msdldt.ui.search.text.FileSearchQuery;

public class NewTextSearchEngine
extends TextSearchEngine {
    private int fLimitTo;
    private int fSearchFor;
    private boolean fIsIncludeAll;
    private boolean fOnlyCompiled;
    private boolean fRegexp;
    private String fSearchString;
    private String fSearchType;

    public NewTextSearchEngine(int limitTo, int searchFor, boolean isIncludeAll, boolean isOnlyCompiled, FileSearchQuery query) {
        this.fLimitTo = limitTo;
        this.fSearchFor = searchFor;
        this.fIsIncludeAll = isIncludeAll;
        this.fOnlyCompiled = isOnlyCompiled;
        this.fRegexp = query.isRegexSearch();
        this.fSearchString = query.getSearchString();
        this.fSearchType = query.getSearchType();
    }

    public IStatus search(TextSearchScope scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
        if (this.fSearchFor == 4) {
            return new TextSearchVisitor(requestor, searchPattern, this.fLimitTo == 2, this.fOnlyCompiled).search(scope, monitor);
        }
        return new TypeSearchVisitor(requestor, searchPattern, this.fSearchType, this.fSearchFor, this.fIsIncludeAll).search(scope, monitor);
    }

    public IStatus search(IFile[] scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
        return null;
    }

    public IStatus search(IRfNamedElement fRfElement, FileTextSearchScope scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
        return new ReferenceSearchVisitor(fRfElement, requestor, searchPattern, this.fSearchType, true, this.fIsIncludeAll, this.fRegexp, this.fSearchString).search((TextSearchScope)scope, monitor);
    }
}

