/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.search;

import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.search.BaseSearchQueryProvider;
import ro.amiq.dvt.ui.search.SearchManager;
import ro.amiq.dvt.ui.search.TextSearchPageInput;
import ro.amiq.msdldt.ui.search.DeclarationsSearchQuery;
import ro.amiq.msdldt.ui.search.ReferenceSearchPageInput;
import ro.amiq.msdldt.ui.search.ReferenceSearchQuery;
import ro.amiq.msdldt.ui.search.text.FileSearchQuery;

public class SearchQueryProvider
extends BaseSearchQueryProvider {
    private int fLimitTo;
    private int fSearchFor;
    private boolean fIsIncludeAll;
    private boolean fOnlyCompiled;

    public SearchQueryProvider(int limitTo, int searchFor, boolean isIncludeAll, boolean isOnlyCompiled) {
        this.fLimitTo = limitTo;
        this.fSearchFor = searchFor;
        this.fIsIncludeAll = isIncludeAll;
        this.fOnlyCompiled = isOnlyCompiled;
        SearchManager.getInstance().getPositionTracker();
    }

    public ISearchQuery createQuery(TextSearchQueryProvider.TextSearchInput input) {
        boolean wholeWord;
        FileTextSearchScope scope = input.getScope();
        String text = input.getSearchText();
        boolean regEx = input.isRegExSearch();
        boolean caseSensitive = input.isCaseSensitiveSearch();
        boolean bl = wholeWord = regEx ? false : ((TextSearchPageInput)input).isWholeWordSearch();
        if (input instanceof ReferenceSearchPageInput) {
            IRfNamedElement element = ((ReferenceSearchPageInput)input).getRfElement();
            String searchLabel = element.getFullNameLabel();
            return new ReferenceSearchQuery(this.getProject(element, input), this.getSearchType(element), element, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIsIncludeAll, this.fSearchFor);
        }
        String searchLabel = text;
        if (this.fSearchFor == 2) {
            searchLabel = String.valueOf(searchLabel) + "()";
        }
        if (this.fLimitTo == 0) {
            return new DeclarationsSearchQuery(this.getSearchType(), text, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIsIncludeAll, this.fOnlyCompiled, this.fSearchFor);
        }
        return new FileSearchQuery(this.getSearchType(), text, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIsIncludeAll, this.fOnlyCompiled, this.fSearchFor);
    }

    protected String getSearchType() {
        switch (this.fSearchFor) {
            case 0: {
                return "Type";
            }
            case 1: {
                return "Field";
            }
            case 2: {
                return "Function";
            }
            case 3: {
                return "Pool";
            }
        }
        return "Text";
    }
}

