/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.search.instances;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseInstancesSearchQuery;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.InstanceMatch;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.ui.search.instances.InstancesSearchResult;

public final class InstancesSearchQuery
extends BaseInstancesSearchQuery {
    public InstancesSearchQuery(IRfNamedElement element) {
        super(element);
    }

    protected AbstractTextSearchResult makeSearchResult() {
        return new InstancesSearchResult((ISearchQuery)this);
    }

    public void computeInstances(IProgressMonitor progressMonitor, IReportHitsListener<InstanceMatch> reportInstancesListener, IRfNamedElement namedElement) {
        if (!RfSearchUtils.isInstantiable((IRfNamedElement)namedElement)) {
            return;
        }
        IRfSingleLangProject singleLangProject = namedElement.getRfProject();
        if (!(singleLangProject instanceof RfProject)) {
            return;
        }
        RfProject rfProject = (RfProject)singleLangProject;
        Collection<RfFileDef> allFiles = rfProject.getFiles();
        if (allFiles == null || allFiles.isEmpty()) {
            return;
        }
        AtomicInteger checkForQueryInterruptionCounter = new AtomicInteger();
        for (RfFileDef file : allFiles) {
            Collection<RfDefElement> children;
            if (file == null || (children = file.getChildren()) == null || children.isEmpty()) continue;
            for (RfDefElement child : children) {
                this.visitDefElement(child, namedElement, reportInstancesListener, progressMonitor, checkForQueryInterruptionCounter);
            }
        }
    }

    private void visitDefElement(RfDefElement defElement, IRfNamedElement namedElement, IReportHitsListener<InstanceMatch> instancesReporterListener, IProgressMonitor progressMonitor, AtomicInteger checkForQueryInterruptionCounter) {
        Collection<RfDefElement> children;
        RfField field;
        RfNamedElement associatedType;
        RfNamedElement element;
        if (checkForQueryInterruptionCounter.getAndIncrement() == 20) {
            if (progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            checkForQueryInterruptionCounter.set(0);
        }
        if ((element = defElement.getNamedElement()) instanceof RfField && ((RfField)element).isInstance() && (associatedType = (field = (RfField)element).getAssociatedType()) != null && associatedType.checkEquals(namedElement)) {
            this.addMatch(defElement, associatedType.getName(), instancesReporterListener);
        }
        if ((children = defElement.getChildren()) == null || children.isEmpty()) {
            return;
        }
        for (RfDefElement child : children) {
            this.visitDefElement(child, namedElement, instancesReporterListener, progressMonitor, checkForQueryInterruptionCounter);
        }
    }

    private void addMatch(RfDefElement defElement, String highlightedElement, IReportHitsListener<InstanceMatch> instancesReporterListener) {
        if (defElement == null) {
            return;
        }
        instancesReporterListener.addMatch((Object)new InstanceMatch(defElement.getParserPath(), defElement.getStartOffset(), defElement.getEndOffset(), defElement.getStartLine(), defElement.getEndLine(), highlightedElement, false));
    }

    public void addInstanceMatch(InstanceMatch match, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager) {
        ParserPath parserPath = match.getParserPath();
        if (!parserPath.equals((Object)this.fCurrentParserPath)) {
            RfReferencesUtils.flushMatches((Set)this.fCachedMatches, (AbstractTextSearchResult)this.fSearchResult);
        }
        this.fCurrentParserPath = parserPath;
        int startLine = match.getStartLine();
        int endLine = match.getEndLine();
        int startOffset = match.getStartOffset();
        int endOffset = match.getEndOffset();
        if (!fileManager.isSynchedFile(parserPath, this.fProject)) {
            return;
        }
        IDocument document = documentManager.getDocument(parserPath, this.fProject);
        if (document == null) {
            return;
        }
        String lineContents = "";
        int lineOffset = 0;
        try {
            lineOffset = document.getLineOffset(startLine - 1);
            IRegion info = document.getLineInformation(startLine < 1 ? 0 : startLine - 1);
            lineContents = document.get(info.getOffset(), info.getLength());
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        int startSearchOffset = startOffset - lineOffset;
        int endSearchOffset = endOffset - lineOffset;
        if (startLine != endLine || startOffset <= endOffset) {
            endSearchOffset = lineContents.length();
        }
        String highlightedElement = match.getHighlightedElement();
        int localOffset = lineContents.indexOf(highlightedElement);
        if (match.isEscaped()) {
            --localOffset;
        }
        int hitOffset = localOffset;
        boolean isSubStringOfAnotherId = false;
        while (RfReferencesUtils.isContainedInAnotherIdentifierFromLineContent((String)highlightedElement, (String)lineContents, (int)startSearchOffset, (int)endSearchOffset, (int)localOffset, (boolean)match.isEscaped())) {
            isSubStringOfAnotherId = true;
            if ((localOffset = lineContents.indexOf(highlightedElement, localOffset + highlightedElement.length() + 1)) == -1 || localOffset > endOffset - lineOffset) break;
            hitOffset = localOffset;
        }
        if (!isSubStringOfAnotherId && match.isEscaped()) {
            ++hitOffset;
        }
        int offset = hitOffset + lineOffset;
        IFile file = DVTFileUtils.getInstance().findProjectFile(this.fProject, parserPath.path);
        if (file == null) {
            return;
        }
        LineElement lineEntry = new LineElement((IResource)file, startLine, offset, lineContents);
        String scopeInfo = RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)parserPath, (int)lineEntry.getLine(), (int)lineEntry.getOffset(), (boolean)false);
        lineEntry.setExtraInfo(scopeInfo);
        int counter = 0;
        try {
            counter = RfReferencesUtils.countStartWS((String)lineContents);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (counter == -1) {
            return;
        }
        lineEntry.setSearchedElement(highlightedElement, offset - lineOffset - counter, false);
        BaseFileMatch fileMatch = new BaseFileMatch(file, offset, highlightedElement.length(), false, lineEntry);
        this.fCachedMatches.add(fileMatch);
    }
}

