/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.syntaxerrors;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.MSDLProblemCategories;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.msdldt.model.IMSDLReparseListener;
import ro.amiq.msdldt.model.MSDLModelManager;
import ro.amiq.msdldt.model.problems.Bridge;
import ro.amiq.msdldt.parser.MSDLProblem;

public class SyntaxErrorsManager
implements IMSDLReparseListener {
    private static volatile SyntaxErrorsManager fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyntaxErrorsManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new SyntaxErrorsManager();
            }
        }
        return fInstance;
    }

    private SyntaxErrorsManager() {
        DVTProblemsUiUpdaterRegistry.register((DVTProblemsUiUpdater)new DVTProblemsUiUpdater(MSDLProblemCategories.MSDL_SYNTAX));
    }

    public void startup() {
        MSDLModelManager.getInstance().addReparseListener(this);
    }

    public void shutdown() {
        MSDLModelManager.getInstance().removeReparseListener(this);
    }

    public void reparsed(int buildKind, int type, IResource resource, List errors, List warnings, List tasks) {
        if ((type & 2) == 0) {
            return;
        }
        if (resource == null) {
            return;
        }
        if (!resource.isAccessible() || !(resource instanceof IFile)) {
            return;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(resource.getProject(), "F73646C")) {
            return;
        }
        IPath location = resource.getLocation();
        DVTProblemManager.getInstance().removeProblemsWithCategoryAndPath(project, MSDLProblemCategories.MSDL_SYNTAX, Utils.canonicPath((IPath)location));
        if (errors != null && !errors.isEmpty()) {
            for (Object error : errors) {
                DVTProblemManager.getInstance().reportProblem(Bridge.fromError(project, (MSDLProblem)error, Utils.canonicPath((IPath)location), buildKind == 1));
            }
        }
        if (warnings != null && !warnings.isEmpty()) {
            for (Object warning : warnings) {
                DVTProblemManager.getInstance().reportProblem(Bridge.fromWarning(project, (MSDLProblem)warning, Utils.canonicPath((IPath)location), buildKind == 1));
            }
        }
        DVTProblemsUiUpdaterRegistry.get((String)MSDLProblemCategories.MSDL_SYNTAX.getId()).update((IFile)resource, buildKind == 1);
    }

    public void updateProblemsUI(IProject project, List<MSDLProblem> unreportedErrors) {
        for (MSDLProblem error : unreportedErrors) {
            DVTProblemManager.getInstance().reportProblem(Bridge.fromError(project, error, error.getFileName(), true));
        }
        DVTProblemsUiUpdaterRegistry.get((String)MSDLProblemCategories.MSDL_SYNTAX.getId()).updateOutsideErrors(project);
    }
}

