/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.utils;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.msdldt.ui.MSDLFileLabelProvider;
import ro.amiq.msdldt.ui.editor.MSDLFileEditorInput;

public class MSDLFileUtils
extends DVTFileUtils {
    private static volatile MSDLFileUtils fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    protected MSDLFileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MSDLFileUtils getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new MSDLFileUtils();
            }
        }
        return fInstance;
    }

    public void openEditor(File file, int line, String selectIdentifier) {
        try {
            if (file.exists()) {
                MSDLFileEditorInput editorInput = new MSDLFileEditorInput(file);
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)editorInput, (String)"ro.amiq.msdldt.ui.editor.MSDLEditor");
                this.selectAndReveal(line, selectIdentifier, editorPart);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IFile selectFile(final IFile[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        final IFile[] result = new IFile[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new MSDLFileLabelProvider2());
                dialog.setElements((Object[])files);
                dialog.setTitle("Select Workspace File");
                dialog.setMessage("The selected file is referenced by multiple linked resources in the workspace.\nSelect a workspace resource to open the file.");
                if (dialog.open() == 0) {
                    result[0] = (IFile)dialog.getFirstResult();
                }
            }
        });
        return result[0];
    }

    public IProject selectProject(IProject[] projects, String message, IProject defaultSelection) {
        return ro.amiq.dvt.ui.Utils.selectProject((IProject[])projects, (String)message, (ILabelProvider)new MSDLFileLabelProvider2(), (IProject)defaultSelection);
    }

    private void internalOpenEditor(IProject project, File classicFile, int line, String selectIdentifier) {
        IFile candidate = this.getProjectFile(project, classicFile.getAbsolutePath());
        if (candidate == null) {
            this.openEditor(classicFile, line, selectIdentifier);
            return;
        }
        this.openEditor(candidate, line, selectIdentifier);
    }

    public void openFile(IProject project, String knownPath, int line, String selectIdentifier) {
        String customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        IFile candidate = this.findProjectFile(project, knownPath);
        if (candidate != null) {
            this.openEditor(candidate, line, selectIdentifier);
            return;
        }
        Path path = new Path(Utils.canonicPath((String)knownPath));
        File classicFile = path.toFile();
        if (path.isAbsolute()) {
            this.internalOpenEditor(project, classicFile, line, selectIdentifier);
            return;
        }
        classicFile = new File(customPath);
        this.internalOpenEditor(project, classicFile, line, selectIdentifier);
    }

    static class MSDLFileLabelProvider2
    extends MSDLFileLabelProvider {
        MSDLFileLabelProvider2() {
        }

        @Override
        protected String decorateText(String input, Object element) {
            if (element instanceof IFile) {
                return ((IFile)element).getFullPath().toOSString();
            }
            if (element instanceof IFolder) {
                return ((IFolder)element).getProjectRelativePath().toOSString();
            }
            return input;
        }
    }
}

