/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.indexer.IIdentifierIndexerExtension;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.model.IMSDLModel;
import ro.amiq.msdldt.model.IMSDLProject;
import ro.amiq.msdldt.model.MSDLModelManager;
import ro.amiq.msdldt.model.indexer.IdentifierIndexer;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.semantic.RfSemanticError;
import ro.amiq.msdldt.model.reflection.semantic.SemanticErrorsManager;
import ro.amiq.msdldt.model.reflection.views.MSDLQuickViewersUtil;
import ro.amiq.msdldt.parser.MSDLFileInstance;
import ro.amiq.msdldt.parser.MSDLFileInstancesMap;
import ro.amiq.msdldt.ui.editor.MSDLEditor;
import ro.amiq.msdldt.ui.editor.highlight.MSDLSemanticHighlighter;
import ro.amiq.msdldt.utils.UtilsCommon;

public class Utils
extends UtilsCommon {
    public static String getFileExtension(File file) {
        return ro.amiq.dvt.utils.Utils.getFileExtension((File)file);
    }

    public static String getFileExtension(String fileName) {
        return ro.amiq.dvt.utils.Utils.getFileExtension((String)fileName);
    }

    public static String getFileNameNoExtension(File file) {
        return ro.amiq.dvt.utils.Utils.getFileNameNoExtension((File)file);
    }

    public static String getFileNameNoExtension(String fileName) {
        return ro.amiq.dvt.utils.Utils.getFileNameNoExtension((String)fileName);
    }

    public static String getFileName(File file) {
        return ro.amiq.dvt.utils.Utils.getFileName((File)file);
    }

    public static IResource getFileAdapter(RfProject rfProject, String fullPath) {
        return DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(rfProject.getProject(), fullPath);
    }

    public static String getCrossPlatformPath(String inputPath) {
        return DVTUtilsCommon.INSTANCE.getCrossPlatformPath(inputPath);
    }

    public static void cleanSemanticMarkers(IProject project) {
        SemanticErrorsManager.getInstance().clean(project);
    }

    public static void triggerSemanticMarkers(RfProject rfProject, Map<String, Collection<RfSemanticError>> semanticErrors, boolean toConsole) {
        SemanticErrorsManager.getInstance().reparsed(rfProject.getProject(), semanticErrors, toConsole);
    }

    public static void connectActiveOpenEditor(RfProject rfProject) {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            try {
                if (rfProject.getFileEditors() == null) {
                    return;
                }
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench == null) {
                    return;
                }
                IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                if (activePage == null) {
                    return;
                }
                IEditorPart editor = activePage.getActiveEditor();
                if (editor == null) {
                    return;
                }
                if (editor instanceof MSDLEditor) {
                    IFile file = (IFile)editor.getAdapter(IResource.class);
                    if (file == null) {
                        return;
                    }
                    ParserPath parserPath = rfProject.resource2parser((IResource)file);
                    if (parserPath == null) {
                        return;
                    }
                    if (!rfProject.isCompiled(parserPath)) {
                        MSDLQuickViewersUtil.getInstance().scheduleReparseIfNonTop((ITextEditor)((DVTEditor)editor));
                        return;
                    }
                    rfProject.connectFileToDocument(parserPath, (DVTEditor)editor, false);
                    rfProject.notifyParsingEndUsingParserPath(new HashSet<ParserPath>(Arrays.asList(parserPath)));
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public static IIdentifierIndexerExtension getIndexer(IProject project) {
        return IdentifierIndexerManager.getInstance().getProjectIndexer(IdentifierIndexer.class, project);
    }

    public static void runOnDisplayThread(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    public static void refreshMarkers(RfProject rfProject) {
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])new Object[]{rfProject});
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.DifferentColorsDecorator", (Object[])new Object[]{rfProject});
    }

    public static int maxIssuesKindNumber(IProject project) {
        int maxIssuesKindNumber = BuildConfigManager.getMaxNofSyntacticProblemsPerFile((IProject)project);
        return maxIssuesKindNumber;
    }

    public static IMSDLProject getMSDLProject(IProject project) {
        IMSDLModel pssModel = MSDLModelManager.getInstance().getMSDLModel();
        IMSDLProject pssProject = pssModel.getMSDLProject(project);
        return pssProject;
    }

    public static IPath getStateLocation() {
        return MSDLPlugin.getDefault().getStateLocation();
    }

    public static void startHighlight(IRfFileDef fileDef, DVTEditor editor) {
        if (fileDef == null || editor == null) {
            return;
        }
        DVTHlUtils.startHighlight((IRfFileDef)fileDef, (DVTEditor)editor, (DVTSemanticHighlighter)new MSDLSemanticHighlighter(editor.getDocument()), (AbstractUIPlugin)MSDLPlugin.getDefault(), (String)"highlight.semantic");
        ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
    }

    public static void connectPragmaCodePositions(IDocument document, RfFileDef fileDef, Set<DVTSemanticFoldingPosition> foldingPositions) {
        try {
            if (document == null || fileDef == null || foldingPositions == null) {
                return;
            }
            if (document.containsPositionCategory("CUSTOM_PRAGMA")) {
                try {
                    document.removePositionCategory("CUSTOM_PRAGMA");
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            document.addPositionCategory("CUSTOM_PRAGMA");
            if (BuildConfigManager.getCustomPragmas((IProject)fileDef.getRfProject().getProject()).isEmpty()) {
                return;
            }
            List<CustomPragmaUsage> customPragmas = Utils.getCustomPragmas(fileDef.getRfProject(), fileDef.getParserPath());
            if (customPragmas == null) {
                ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"CUSTOM_PRAGMA");
                return;
            }
            ro.amiq.dvt.ui.Utils.addCustomPragmasPositions(customPragmas, foldingPositions, (IDocument)document);
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"CUSTOM_PRAGMA");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static List<CustomPragmaUsage> getCustomPragmas(RfProject rfProject, ParserPath parserPath) {
        if (rfProject == null || parserPath == null) {
            return null;
        }
        MSDLFileInstancesMap fileInstancesMap = rfProject.getFileInstancesMap();
        if (fileInstancesMap == null) {
            return null;
        }
        List<MSDLFileInstance> instances = fileInstancesMap.getFileInstances(parserPath);
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        ArrayList<CustomPragmaUsage> result = new ArrayList<CustomPragmaUsage>();
        for (MSDLFileInstance instance : instances) {
            result.addAll(instance.getCustomPragmas());
        }
        return result;
    }

    public static void setCustomPragmas(RfProject rfProject, ParserPath parserPath, List<CustomPragmaUsage> pragmas) {
        if (rfProject == null || parserPath == null) {
            return;
        }
        MSDLFileInstancesMap fileInstancesMap = rfProject.getFileInstancesMap();
        if (fileInstancesMap == null) {
            return;
        }
        List<MSDLFileInstance> instances = fileInstancesMap.getFileInstances(parserPath);
        if (instances == null || instances.isEmpty()) {
            return;
        }
        for (MSDLFileInstance instance : instances) {
            instance.cleanCustomPragmas();
        }
        instances.get(0).setCustomPragmas(pragmas);
    }

    public static int getCodeFoldingNofLines() {
        return MSDLPlugin.getDefault().getPreferenceStore().getInt("editor.numberOfLines");
    }

    public static void startUpdateScopeBreadcrumb(DVTEditor editor) {
        if (editor == null) {
            return;
        }
        IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        if (!activePage.isPartVisible((IWorkbenchPart)editor)) {
            Utils.setReadOnlyBreadcrumbs(editor, false);
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                Utils.setReadOnlyBreadcrumbs(editor, false);
                ScopeBreadcrumbConfiguration configuration = new ScopeBreadcrumbConfiguration(editor.getCursorScopeForBreadcrumb(true), editor.getCursor(), (IFile)editor.getAdapter(IResource.class), true);
                editor.updateBreadcrumb(ScopeBreadcrumbViewer.class, (AbstractBreadcrumbConfiguration)configuration);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError(e.getMessage());
            }
        });
    }

    public static void setReadOnlyBreadcrumbs(DVTEditor editor, boolean isReadOnly) {
        IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        boolean forceReadOnly = false;
        if (activePage.isPartVisible((IWorkbenchPart)editor)) {
            forceReadOnly = true;
        }
        List breadcrumbViewers = editor.getBreadcrumbViewers();
        for (AbstractBreadcrumbViewer breadcrumb : breadcrumbViewers) {
            if (!(breadcrumb instanceof ThickBreadcrumbViewer)) continue;
            ((ThickBreadcrumbViewer)breadcrumb).setModelReady(!isReadOnly);
            if (!forceReadOnly) continue;
            ((ThickBreadcrumbViewer)breadcrumb).changeReadOnlyState();
        }
    }
}

