/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfProject;

public class UtilsCommon {
    public static RfProject getRfProject(IProject project) {
        return RfManager.getInstance().getRfProject(project);
    }

    public static int documentLength(IDocument document) {
        return document.getLength();
    }

    public static int documentNumberOfLines(Object document) {
        return ((IDocument)document).getNumberOfLines();
    }

    public static int documentLineOffset(Object document, int line) throws Exception {
        return ((IDocument)document).getLineOffset(line);
    }

    public static void addDocumentPosition(Object document, String category, Object position) throws Exception {
        if (!((IDocument)document).containsPositionCategory(category)) {
            return;
        }
        ((IDocument)document).addPosition(category, (Position)position);
    }

    public static int convertLineToOffset(Object document, int line) {
        block3: {
            try {
                if (document != null) break block3;
                return -1;
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return ((IDocument)document).getLineOffset(line - 1);
    }

    public static int convertPositionToLine(Object document, int offset) {
        try {
            if (document != null && ((IDocument)document).getLength() > offset) {
                return ((IDocument)document).getLineOfOffset(offset) + 1;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    public static Object createPosition(int offset, int length) {
        return new DVTPosition(offset, length);
    }

    public static boolean positionDeleted(Object position) {
        return ((Position)position).isDeleted;
    }

    public static int positionLength(Object position) {
        return ((Position)position).length;
    }

    public static int positionOffset(Object position) {
        return ((Position)position).offset;
    }

    public static int getEndOffset(Object position) {
        if (position != null) {
            return ((Position)position).getOffset() + ((Position)position).getLength();
        }
        return 0;
    }

    public static int getStartOffset(Object position) {
        if (position != null) {
            return ((Position)position).getOffset();
        }
        return 0;
    }

    public static String getFileName(String pathString) {
        return Utils.getFileName((String)pathString);
    }
}

