/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum DVTEclipseCDTUtils {
    INSTANCE;

    public static final String DOT_C_PROJECT_FILE = ".cproject";
    public static final String DOT_C_PROJECT_FILE_BACKUP = ".cproject.bkp";

    protected void backupDotCProjectFiles() {
        Job backupDotCProjectJob = new Job("Backup .cproject files"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    if (projects == null) {
                        return Status.OK_STATUS;
                    }
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        if (DVTEclipseCDTUtils.this.checkNoCPPProjectNature(project)) {
                            DVTEclipseCDTUtils.this.backupDotCProjectFromFileSystem(project);
                        }
                        ++n2;
                    }
                }
                catch (IOException | CoreException e) {
                    DVTLogger.INSTANCE.logError(e);
                }
                return Status.OK_STATUS;
            }
        };
        backupDotCProjectJob.setUser(true);
        backupDotCProjectJob.schedule();
    }

    public boolean checkNoCPPProjectNature(IProject project) throws CoreException {
        if (!project.isAccessible()) {
            return false;
        }
        return !project.hasNature(LanguageKind.CPP.NATURE_ID) && !project.hasNature(LanguageKind.CPP_EXT.NATURE_ID);
    }

    private void backupDotCProjectFromFileSystem(IProject project) throws IOException {
        IPath location = project.getLocation();
        if (location == null) {
            return;
        }
        File cProjectFile = location.append(DOT_C_PROJECT_FILE).toFile();
        if (cProjectFile == null || !cProjectFile.exists()) {
            return;
        }
        File cProjectFileBackup = location.append(DOT_C_PROJECT_FILE_BACKUP).toFile();
        Files.move(cProjectFile.toPath(), cProjectFileBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public void backupDotCProjectFile(IProject project, IProgressMonitor monitor) throws CoreException {
        IFile cProjectFile = project.getFile(DOT_C_PROJECT_FILE);
        if (!cProjectFile.exists()) {
            return;
        }
        IPath cProjectFileBackupPath = Path.fromOSString((String)DOT_C_PROJECT_FILE_BACKUP);
        if (cProjectFileBackupPath == null) {
            return;
        }
        IFile cProjectBackupFile = project.getFile(DOT_C_PROJECT_FILE_BACKUP);
        if (cProjectBackupFile.exists()) {
            cProjectBackupFile.delete(true, monitor);
        }
        cProjectFile.refreshLocal(0, monitor);
        cProjectFile.move(cProjectFileBackupPath, 1, monitor);
    }
}

