/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.io.File;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTProcessRunner;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTExternalProgramOutputCache {
    public static final String DVT_EXTERNAL_PROGRAM_TIMEOUT = "DVT_EXTERNAL_PROGRAM_TIMEOUT";
    public static final String DVT_NEVER_RUN_SN_WHICH = "DVT_NEVER_RUN_SN_WHICH";
    public static final String IRUN_LOCATION = "irun -location -nolog -nohistory";
    public static final String IRUN_VERSION = "irun -version -nolog -nohistory";
    public static final String XRUN_LOCATION = "xrun -location -nolog -nohistory";
    public static final String XRUN_VERSION = "xrun -version -nolog -nohistory";
    public static final String SPECMAN_H_LOCATION = "sn_which.sh specman.h";
    private static final Pattern LOCATION_OF_INSTALLATION_PATTERN = Pattern.compile("^Location of installation:");
    private static final Pattern WHITESPACES_PATTERN = Pattern.compile("\\s+");
    private static final Pattern IRUN_PATTERN = Pattern.compile("TOOL:\\s+(?:[ix])run\\s+([0-9]+\\.[0-9]+-s[0-9]+)", 2);
    private static final int DEFAULT_TIMEOUT_MILLIS = 20000;
    private static final int TIMEOUT_MILLIS;
    public static final File WORKING_DIR;
    private static volatile DVTExternalProgramOutputCache fInstance;
    private static final Object fSyncInstance;
    private static Set<LanguageKind> fLanguages;
    private Map<String, DVTExternalProgram> fDVTExternalPrograms = new ConcurrentHashMap<String, DVTExternalProgram>();

    static {
        int envVal = 20000;
        try {
            String envStringVal = System.getenv(DVT_EXTERNAL_PROGRAM_TIMEOUT);
            if (envStringVal != null) {
                envVal = Integer.parseInt(envStringVal);
            }
            if (envVal == 0) {
                envVal = Integer.MAX_VALUE;
            }
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
        TIMEOUT_MILLIS = envVal;
        WORKING_DIR = DVTExternalProgramOutputCache.getWorkingDir();
        fSyncInstance = new Object();
        fLanguages = EnumSet.of(LanguageKind.E, LanguageKind.SLN, LanguageKind.VLOG, LanguageKind.VHDL);
    }

    private static File getWorkingDir() {
        try {
            File workingDir;
            String tmpdir = System.getProperty("java.io.tmpdir");
            if (tmpdir != null && (workingDir = new File(tmpdir)).isDirectory()) {
                return workingDir;
            }
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DVTExternalProgramOutputCache getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new DVTExternalProgramOutputCache();
            }
        }
        return fInstance;
    }

    public static synchronized void batchInit(Set<LanguageKind> languageKinds) {
        fLanguages = languageKinds;
        DVTExternalProgramOutputCache.getInstance();
    }

    private DVTExternalProgramOutputCache() {
        if (fLanguages.contains((Object)LanguageKind.E) || fLanguages.contains((Object)LanguageKind.VLOG)) {
            DVTExternalProgram.runExternalProgram(IRUN_LOCATION, TIMEOUT_MILLIS, this.fDVTExternalPrograms, (externalProgram, dvtProcessRunner) -> {
                String[] lines;
                String[] stringArray = lines = DVTStringUtil.split(DVTStringUtil.NEW_LINE, dvtProcessRunner.getStandardOutput());
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.trim().startsWith("Location of installation:")) {
                        String trimedLine = line.trim();
                        String locationPatternRemoved = DVTStringUtil.replaceFirst(LOCATION_OF_INSTALLATION_PATTERN, trimedLine, "");
                        externalProgram.result.value = DVTStringUtil.replaceAll(WHITESPACES_PATTERN, locationPatternRemoved, "");
                        break;
                    }
                    ++n2;
                }
            });
            DVTExternalProgram.runExternalProgram(IRUN_VERSION, TIMEOUT_MILLIS, this.fDVTExternalPrograms, (externalProgram, dvtProcessRunner) -> {
                String[] lines;
                String[] stringArray = lines = DVTStringUtil.split(DVTStringUtil.NEW_LINE, dvtProcessRunner.getStandardOutput());
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    Matcher matcher = IRUN_PATTERN.matcher(line);
                    if (matcher.find()) {
                        externalProgram.result.value = matcher.group(1);
                        break;
                    }
                    ++n2;
                }
            });
            DVTExternalProgram.runExternalProgram(XRUN_LOCATION, TIMEOUT_MILLIS, this.fDVTExternalPrograms, (externalProgram, dvtProcessRunner) -> {
                String[] lines;
                String[] stringArray = lines = DVTStringUtil.split(DVTStringUtil.NEW_LINE, dvtProcessRunner.getStandardOutput());
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.trim().startsWith("Location of installation:")) {
                        String trimedLine = line.trim();
                        String locationPatternRemoved = DVTStringUtil.replaceFirst(LOCATION_OF_INSTALLATION_PATTERN, trimedLine, "");
                        externalProgram.result.value = DVTStringUtil.replaceAll(WHITESPACES_PATTERN, locationPatternRemoved, "");
                        break;
                    }
                    ++n2;
                }
            });
            DVTExternalProgram.runExternalProgram(XRUN_VERSION, TIMEOUT_MILLIS, this.fDVTExternalPrograms, (externalProgram, dvtProcessRunner) -> {
                String[] lines;
                String[] stringArray = lines = DVTStringUtil.split(DVTStringUtil.NEW_LINE, dvtProcessRunner.getStandardOutput());
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    Matcher matcher = IRUN_PATTERN.matcher(line);
                    if (matcher.find()) {
                        externalProgram.result.value = matcher.group(1);
                        break;
                    }
                    ++n2;
                }
            });
        }
        if (fLanguages.contains((Object)LanguageKind.E)) {
            DVTExternalProgram.runExternalProgram(SPECMAN_H_LOCATION, TIMEOUT_MILLIS, this.fDVTExternalPrograms, null);
        }
    }

    public synchronized DVTExternalProgram get(String commandline) {
        DVTExternalProgram result = this.fDVTExternalPrograms.get(commandline);
        if (result == null) {
            DVTExternalProgram.runExternalProgram(commandline, TIMEOUT_MILLIS, this.fDVTExternalPrograms, null);
            result = this.fDVTExternalPrograms.get(commandline);
        }
        return result;
    }

    public Map<String, DVTExternalProgram> getAllExternalProgams() {
        return this.fDVTExternalPrograms;
    }

    public static class DVTExternalProgram {
        private String fCommandLine;
        private boolean fWasAcessed;
        private DVTProcessRunner fProcessRunner;
        protected Result result = new Result();
        private Thread runningCommandThread;

        private static void runExternalProgram(String commandLine, int timeout, Map<String, DVTExternalProgram> externalPrograms, final BiConsumer<DVTExternalProgram, DVTProcessRunner> consumer) {
            DVTExternalProgram externalProgram = new DVTExternalProgram(commandLine, timeout){

                @Override
                protected void postProcess(DVTProcessRunner dvtProcessRunner) {
                    if (consumer != null) {
                        consumer.accept(this, dvtProcessRunner);
                    } else {
                        super.postProcess(dvtProcessRunner);
                    }
                }
            };
            externalPrograms.put(commandLine.trim(), externalProgram);
            if (externalProgram.runningCommandThread == null) {
                return;
            }
            externalProgram.runningCommandThread.start();
        }

        private DVTExternalProgram(String commandLine, final int timeout) {
            this.fCommandLine = commandLine;
            final String trimmedCommandLine = commandLine.trim();
            if (trimmedCommandLine == null || trimmedCommandLine.length() == 0) {
                DVTLogger.INSTANCE.logError((Throwable)new IllegalArgumentException("Trying to get the output of an empty commandline."));
                return;
            }
            if (new Boolean(System.getenv(DVTExternalProgramOutputCache.DVT_NEVER_RUN_SN_WHICH)).booleanValue() && trimmedCommandLine.contains("sn_which")) {
                String message = "DVT_NEVER_RUN_SN_WHICH is set so not running: " + trimmedCommandLine;
                DVTLogger.INSTANCE.logInfo(message);
                this.result.done = true;
                this.result.error = message;
                return;
            }
            this.runningCommandThread = new Thread(trimmedCommandLine){

                @Override
                public void run() {
                    block7: {
                        try {
                            fProcessRunner = new DVTProcessRunner(trimmedCommandLine, WORKING_DIR);
                            DVTLogger.INSTANCE.logDebug("[EXTERNAL PROGRAM OUTPUT] '" + fCommandLine + "' started running");
                            fProcessRunner.run(null, timeout);
                            DVTLogger.INSTANCE.logDebug("[EXTERNAL PROGRAM OUTPUT] '" + fCommandLine + "' finised running");
                            this.postProcess(fProcessRunner);
                        }
                        catch (DVTProcessRunner.TimeoutException timeoutException) {
                            result.timedout = true;
                            DVTLogger.INSTANCE.logDebug("[EXTERNAL PROGRAM OUTPUT] '" + fCommandLine + "' timed out");
                            result.done = true;
                            break block7;
                        }
                        catch (Exception e) {
                            try {
                                result.error = e.getMessage();
                                DVTLogger.INSTANCE.logInfo("[EXTERNAL PROGRAM OUTPUT] '" + fCommandLine + "' error occured: " + e.getMessage());
                                break block7;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                result.done = true;
                            }
                        }
                        result.done = true;
                    }
                    DVTLogger.INSTANCE.logDebug("[EXTERNAL PROGRAM OUTPUT] '" + fCommandLine + "' done: " + result.toString());
                }
            };
        }

        protected void postProcess(DVTProcessRunner dvtProcessRunner) {
            this.result.value = dvtProcessRunner.getStandardOutput();
            if (this.result.value != null) {
                this.result.value = this.result.value.trim();
                if (this.result.value.isEmpty()) {
                    this.result.value = null;
                }
            }
            if (dvtProcessRunner.getExitValue() != 0) {
                this.result.error = dvtProcessRunner.getErrorOutput();
            }
        }

        public Result getResult(boolean blocking) {
            this.fWasAcessed = true;
            while (blocking && !this.result.done) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.result;
        }

        public String getCommandLine() {
            return this.fCommandLine;
        }

        boolean isDone() {
            return this.result.done;
        }

        boolean wasAccessed() {
            return this.fWasAcessed;
        }

        public static class Result {
            public String value;
            private String error;
            private boolean timedout;
            private boolean done;

            public String toString() {
                return "[value=" + this.value + ", error=" + this.error + ", timedout=" + this.timedout + ", done=" + this.done + "]";
            }

            public boolean isValid() {
                return this.done && !this.timedout && this.error == null && this.value != null;
            }

            public String getInvalidReason() {
                if (!this.done) {
                    return "not finished";
                }
                if (this.timedout) {
                    return "timed out";
                }
                if (this.error != null) {
                    return "error: " + this.error;
                }
                if (this.value == null || this.value.isEmpty()) {
                    return "null value";
                }
                return "valid";
            }

            public boolean isDone() {
                return this.done;
            }
        }
    }
}

