/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTExternalProgramOutputCache;
import ro.amiq.dvt.DVTPlugin;

public class DVTExternalProgramOutputCachePersistence
implements IWorkbenchListener {
    private static final String QUALIFIER = DVTExternalProgramOutputCachePersistence.class.getName();
    private static IPreferenceStore fPrefStore;
    private static volatile DVTExternalProgramOutputCachePersistence fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new DVTExternalProgramOutputCachePersistence();
                PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)fInstance);
                fPrefStore = DVTPlugin.getDefault().getPreferenceStore();
                int i = 0;
                while (i < fPrefStore.getInt(QUALIFIER)) {
                    DVTExternalProgramOutputCache.getInstance().get(fPrefStore.getString(String.valueOf(QUALIFIER) + i));
                    ++i;
                }
            }
        }
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        int i = 0;
        while (i < fPrefStore.getInt(QUALIFIER)) {
            fPrefStore.setToDefault(String.valueOf(QUALIFIER) + i);
            ++i;
        }
        ArrayList<String> accesedCommandLines = new ArrayList<String>();
        for (DVTExternalProgramOutputCache.DVTExternalProgram p : DVTExternalProgramOutputCache.getInstance().getAllExternalProgams().values()) {
            if (!p.wasAccessed()) continue;
            accesedCommandLines.add(p.getCommandLine());
        }
        fPrefStore.setValue(QUALIFIER, accesedCommandLines.size());
        int i2 = 0;
        while (i2 < accesedCommandLines.size()) {
            fPrefStore.setValue(String.valueOf(QUALIFIER) + i2, (String)accesedCommandLines.get(i2));
            ++i2;
        }
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
    }
}

