/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.DVTExternalProgramOutputCache;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTExternalProgramOutputCacheProgessReporter {
    private static final int POLL_FOR_RUNNING_PROGRAMS_DELAY = 300;
    private static final String NAME = "Getting output of external programs";

    public static synchronized void init() {
        new Thread("DVTExternalProgramOutputCacheProgessReporter"){

            @Override
            public void run() {
                while (!DVTPlugin.getDefault().isShuttingDown()) {
                    try {
                        if (DVTExternalProgramOutputCacheProgessReporter.getRemainingPrograms().length() > 0) {
                            Job job = new Job(DVTExternalProgramOutputCacheProgessReporter.NAME){

                                protected IStatus run(IProgressMonitor monitor) {
                                    String remainingPrograms = DVTExternalProgramOutputCacheProgessReporter.getRemainingPrograms();
                                    monitor.beginTask(remainingPrograms, -1);
                                    while (!DVTPlugin.getDefault().isShuttingDown() && (remainingPrograms = DVTExternalProgramOutputCacheProgessReporter.getRemainingPrograms()).length() != 0) {
                                        monitor.setTaskName(remainingPrograms);
                                        monitor.worked(1);
                                        try {
                                            Thread.sleep(300L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    monitor.done();
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setSystem(false);
                            job.setUser(false);
                            DVTJobsUtils.scheduleAndJoin(job);
                        }
                        Thread.sleep(300L);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
        }.start();
    }

    private static String getRemainingPrograms() {
        ArrayList<String> running = new ArrayList<String>();
        for (DVTExternalProgramOutputCache.DVTExternalProgram p : DVTExternalProgramOutputCache.getInstance().getAllExternalProgams().values()) {
            if (p.isDone()) continue;
            running.add(p.getCommandLine());
        }
        return DVTStringUtil.join(running, " && ");
    }
}

