/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IHelpTestChangeListener;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTHelp {
    private static boolean fHelpTest = true;
    private static boolean fSuspended = true;
    private static Timer fTimer;
    private static ArrayList<IHelpTestChangeListener> fLicenseChangeListeners;
    private static long fLastQueryTimestamp;
    private static final long TIMEOUT = 300000L;
    private static final long POLLING = 10000L;

    static {
        fLicenseChangeListeners = new ArrayList();
    }

    public static void addLicenseChangeLister(IHelpTestChangeListener l) {
        fLicenseChangeListeners.add(l);
    }

    public static void startPollingHelp() {
        try {
            if (fTimer != null) {
                return;
            }
            fTimer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (fSuspended) {
                        return;
                    }
                    if (System.currentTimeMillis() - fLastQueryTimestamp > 300000L) {
                        fSuspended = true;
                        return;
                    }
                    boolean currentLicense = DVTPlugin.getDefault().collect().c();
                    if (currentLicense != fHelpTest) {
                        for (IHelpTestChangeListener l : fLicenseChangeListeners) {
                            l.licenseChanged();
                        }
                    }
                    fHelpTest = currentLicense;
                }
            };
            fTimer.schedule(task, 10000L, 10000L);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void stopPoolingHelp() {
        if (fTimer != null) {
            fTimer.cancel();
        }
        fTimer = null;
    }

    public static boolean getHelpTest() {
        fLastQueryTimestamp = System.currentTimeMillis();
        if (fSuspended) {
            fSuspended = false;
        }
        return fHelpTest;
    }

    public static void triggerIndexRebuild() {
        try {
            if (!DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.help.reindex")) {
                return;
            }
            DVTPlugin.getDefault().getPreferenceStore().setValue("ro.amiq.dvt.help.reindex", false);
            File configurationDirectory = DVTHelp.getHelpConfigurationDirectory();
            if (configurationDirectory != null) {
                try {
                    DVTHelp.delete(configurationDirectory);
                }
                catch (IOException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static File getHelpConfigurationDirectory() {
        URL configURL;
        File configurationDirectory = null;
        Location location = Platform.getConfigurationLocation();
        if (location != null && (configURL = location.getURL()) != null && configURL.getProtocol().startsWith("file")) {
            configurationDirectory = new File(configURL.getFile(), "org.eclipse.help.base");
        }
        if (configurationDirectory == null) {
            configurationDirectory = new File(String.valueOf(Platform.getLocation().toOSString()) + File.separator + ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.help.base");
        }
        if (configurationDirectory.exists()) {
            return configurationDirectory;
        }
        return null;
    }

    private static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                DVTHelp.delete(files[i]);
                ++i;
            }
        }
        if (!file.delete()) {
            throw new IOException("Cannot detele file: " + file.getAbsolutePath());
        }
    }
}

