/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditorAssociationOverride;
import ro.amiq.dvt.ui.editor.LargeFileEditor;
import ro.amiq.dvt.utils.DVTFileUtils;

public enum DVTManageLargeFileEditors implements IWorkbenchListener
{
    INSTANCE;

    private IEclipsePreferences.IPreferenceChangeListener fileSizePreferenceChangeListener;

    public void init() {
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
        this.installMaximumFileSizePreferenceListener();
    }

    private void installMaximumFileSizePreferenceListener() {
        try {
            this.fileSizePreferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    try {
                        if (!"editor.maxiumSizeOfFile".equals(event.getKey())) {
                            return;
                        }
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        if (workbench == null) {
                            return;
                        }
                        IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
                        if (activePage == null) {
                            return;
                        }
                        List<IEditorPart> visibleEditors = Utils.computeVisibleEditors();
                        for (IEditorPart editor : visibleEditors) {
                            IFile file;
                            IEditorInput editorInput = editor.getEditorInput();
                            if (editorInput == null || (file = (IFile)editorInput.getAdapter(IFile.class)) == null || !(editor instanceof LargeFileEditor) || DVTFileUtils.isLargeFile(file.getLocationURI())) continue;
                            activePage.closeEditor(editor, false);
                            IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)((FileEditorInput)editorInput).getFile().getName());
                            activePage.openEditor(editorInput, DVTEditorAssociationOverride.getEditorDescriptor(((FileEditorInput)editorInput).getFile(), editorDescriptor).getId());
                        }
                    }
                    catch (PartInitException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            };
            DVTPlugin.getDefault().getPreferences().addPreferenceChangeListener(this.fileSizePreferenceChangeListener);
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        IWorkbenchPage activePage;
        block5: {
            activePage = workbench.getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) break block5;
            return false;
        }
        try {
            IEditorReference[] editorReferences;
            IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IEditorReference editorReference = iEditorReferenceArray[n2];
                IEditorInput editorInput = editorReference.getEditorInput();
                if (editorInput != null && (file = (IFile)editorInput.getAdapter(IFile.class)) != null && !"ro.amiq.dvt.ui.editor.LargeFileEditor".equals(editorReference.getId()) && DVTFileUtils.isLargeFile(file.getLocationURI())) {
                    activePage.closeEditor(editorReference.getEditor(false), false);
                    activePage.openEditor(editorInput, "ro.amiq.dvt.ui.editor.LargeFileEditor", false);
                }
                ++n2;
            }
            return true;
        }
        catch (PartInitException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return true;
        }
    }

    public void postShutdown(IWorkbench workbench) {
    }

    public void dispose() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        workbench.removeWorkbenchListener((IWorkbenchListener)this);
        DVTPlugin.getDefault().getPreferences().removePreferenceChangeListener(this.fileSizePreferenceChangeListener);
    }
}

