/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.INavigatorActivationService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import ro.amiq.dvt.DVTEclipseCDTUtils;
import ro.amiq.dvt.DVTExternalProgramOutputCachePersistence;
import ro.amiq.dvt.DVTExternalProgramOutputCacheProgessReporter;
import ro.amiq.dvt.DVTHelp;
import ro.amiq.dvt.DVTManageLargeFileEditors;
import ro.amiq.dvt.DVTSanityCheck;
import ro.amiq.dvt.DVTSelectionManager;
import ro.amiq.dvt.DVTSplash;
import ro.amiq.dvt.DisableWordWrapFix;
import ro.amiq.dvt.EclipseConfigurationChecker;
import ro.amiq.dvt.MarkerSelectionManager;
import ro.amiq.dvt.SearchViewQueryListener;
import ro.amiq.dvt.SplitEditorFix;
import ro.amiq.dvt.StatusBarInitializer;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.debug.core.intrp.model.IntrpBreakpointListener;
import ro.amiq.dvt.debug.core.model.breakpoints.DVTBreakpointMarkerChangeListener;
import ro.amiq.dvt.debug.ui.actions.DynamicResumeDebuggerButtonContribution;
import ro.amiq.dvt.diagrams.wavedrom.WaveDromManager;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicLaunchConfigToolbar;
import ro.amiq.dvt.dynamicactions.launchconfigs.LaunchConfigListener;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalBuildAutoChangeListener;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.IdleHandler;
import ro.amiq.dvt.resourcemonitor.DVTResourceMonitor;
import ro.amiq.dvt.settings.DVTSPreferencesManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.DeprecatedBuildConfigurationDialog;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.DVTActionManager;
import ro.amiq.dvt.ui.actions.DynamicBuildButtonsContribution;
import ro.amiq.dvt.ui.actions.breadcrumb.BreadcrumbMode;
import ro.amiq.dvt.ui.editor.DirtyEditorSaver;
import ro.amiq.dvt.ui.editor.FileAcessEditorDecorator;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationHelper;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationToolbar;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetectionManager;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.lazy.tree.utils.LazyTreeUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.SwitchToNewViews;
import ro.amiq.dvt.wizards.newfile.NewResourceListener;
import ro.amiq.dvt.workspace.WorkspaceDiskSpaceChecker;

public class DVTPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "ro.amiq.dvt";
    private static DVTPlugin fPlugin;
    private boolean fPluginInitializationDone;
    private volatile boolean fIsSuttingDown = false;
    private IPreferenceStore fCombinedPreferenceStore;
    private DVTSelectionManager fSelectionManager;
    private final DVTSplash fSplash;

    public DVTPlugin() {
        fPlugin = this;
        this.fSelectionManager = new DVTSelectionManager();
        this.fSplash = new DVTSplash();
    }

    public static DVTSelectionManager getSelectionManager() {
        return DVTPlugin.getDefault().fSelectionManager;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DVTLogger.INSTANCE.logDebug(">> Started DVT Plugin (version: " + (String)this.getBundle().getHeaders().get("Bundle-Version") + ").");
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)StatusBarInitializer.INSTANCE);
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                block5: {
                    try {
                        if (event.getType() != 2 || !event.getBundle().getSymbolicName().equals(DVTPlugin.PLUGIN_ID)) break block5;
                        DVTLogger.INSTANCE.logDebug(">> Started DVT initialization.");
                        DVTHelp.startPollingHelp();
                        ExternalToolsUtil.checkSessionSupport();
                        DVTActionManager.init();
                        DVTPlugin.this.backwardCompatibility();
                        RfMixedLangManager.getInstance();
                        FIncrementalNotificationTracker.INSTANCE.setAutoBuildState();
                        try {
                            while (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                                Thread.sleep(50L);
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                        final Display display = PlatformUI.getWorkbench().getDisplay();
                        display.asyncExec(() -> {
                            try {
                                IEditorReference[] editorReferences;
                                DVTLogger.INSTANCE.logDebug(">> Started DVT UI initialization.");
                                DVTPlugin.this.collect().x();
                                DVTPlugin.this.collect().z();
                                DVTPlugin.this.fSelectionManager.pluginStarted();
                                PreferenceUtils.INSTANCE.init();
                                DVTHelp.triggerIndexRebuild();
                                ExternalToolsModelManager.getInstance().init();
                                DirtyEditorSaver.getInstance().start();
                                DVTExternalProgramOutputCachePersistence.init();
                                DVTExternalProgramOutputCacheProgessReporter.init();
                                DVTManageLargeFileEditors.INSTANCE.init();
                                DVTAutoIndentDetectionManager.INSTANCE.init();
                                DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)LaunchConfigListener.INSTANCE);
                                WorkspaceDiskSpaceChecker.getInstance().start();
                                EditorEmulationHelper.INSTANCE.installListeners();
                                DVTPlugin.this.installAutobuildListeners();
                                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)DVTBreakpointMarkerChangeListener.INSTANCE, 1);
                                DVTSanityCheck.checkAutoBuildEnabled();
                                DVTSanityCheck.checkCommonSettingsDir();
                                DynamicLaunchConfigToolbar.INSTANCE.init();
                                DynamicBuildButtonsContribution.INSTANCE.init();
                                DynamicResumeDebuggerButtonContribution.INSTANCE.init();
                                EditorEmulationToolbar.INSTANCE.init();
                                BreadcrumbMode.init();
                                SwitchToNewViews.INSTANCE.start();
                                LazyTreeUtils.computeTreeItemHeight();
                                display.addListener(39, e -> LazyTreeUtils.computeTreeItemHeight());
                                InspectViewSelectionListener.getInstance().init();
                                WaveDromManager.getInstance().init();
                                EclipseConfigurationChecker.excludeDirectivesInEclipseIni();
                                FileAcessEditorDecorator.getInstance();
                                DVTPlugin.this.hideCDTIncludes();
                                DVTEclipseCDTUtils.INSTANCE.backupDotCProjectFiles();
                                BuildEventManager.getInstance().registerListener(DVTViewManager.getInstanceByCurrentWorkbenchWindow());
                                DeprecatedBuildConfigurationDialog.runCheck();
                                IdleHandler.startIdleMonitor(display);
                                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
                                int n = editorReferences.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IEditorReference editorReference = iEditorReferenceArray[n2];
                                    String editorId = editorReference.getId();
                                    if ("org.eclipse.ui.internal.emptyEditorTab".equals(editorId)) {
                                        activePage.closeEditors(new IEditorReference[]{editorReference}, false);
                                    }
                                    ++n2;
                                }
                                ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

                                    public void resourceChanged(IResourceChangeEvent event) {
                                        try {
                                            IResourceDelta delta = event.getDelta();
                                            if (delta == null) {
                                                return;
                                            }
                                            delta.accept(new IResourceDeltaVisitor(){

                                                public boolean visit(IResourceDelta delta) throws CoreException {
                                                    IResource resource = delta.getResource();
                                                    if ((resource.getType() & 8) != 0) {
                                                        return true;
                                                    }
                                                    if ((resource.getType() & 4) != 0 && ((delta.getFlags() & 0x4000) != 0 && delta.getKind() == 4 || (delta.getFlags() & 0x4000) != 0 && delta.getKind() == 1 || (delta.getFlags() == 0 || delta.getFlags() == 131072) && delta.getKind() == 2) && resource instanceof IProject) {
                                                        DVTPlugin.this.collect().z();
                                                        if (!((IProject)resource).isOpen()) {
                                                            Utils.closeOpenEditors(display, (IProject)resource);
                                                            PreprocDiffManager.INSTANCE.clear((IProject)resource);
                                                            DesignPathManager.getInstance().remove((IProject)resource);
                                                            DVTBuildConsoleRegistry.removeConsole((IProject)resource);
                                                        }
                                                    }
                                                    return false;
                                                }
                                            });
                                        }
                                        catch (CoreException coreException) {}
                                    }
                                });
                                PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                                    public boolean preShutdown(IWorkbench workbench, boolean forced) {
                                        return true;
                                    }

                                    public void postShutdown(IWorkbench workbench) {
                                        (this).DVTPlugin.this.fIsSuttingDown = true;
                                    }
                                });
                                ro.amiq.dvt.utils.Utils.workaroundProgessViewBug();
                                if (EclipseUtils.isEclipse4x()) {
                                    ProjectColorUtils.injectCustomColors();
                                    Boolean colorFiles = DVTPlugin.getDefault().getPreferenceStore().getBoolean("perProjectColors");
                                    if (colorFiles.booleanValue()) {
                                        ProjectColorUtils.colorFiles();
                                    }
                                    try {
                                        SplitEditorFix.install();
                                    }
                                    catch (Throwable e2) {
                                        DVTLogger.INSTANCE.logError(e2);
                                    }
                                }
                                DisableWordWrapFix.INSTANCE.install();
                                NewSearchUI.addQueryListener((IQueryListener)SearchViewQueryListener.getInstance());
                                MarkerSelectionManager.INSTANCE.start();
                                if (!TestHelper.isTestMode()) {
                                    DVTPlugin.this.showSplash();
                                }
                                DVTResourceMonitor.start();
                                MemoryMonitor.loadMonitor();
                                DVTPlugin.this.setupIntrpDebug();
                                DVTPlugin.registerNewFileListener();
                                DVTLogger.INSTANCE.logDebug("<< Ended DVT UI initialization.");
                                DVTPlugin.this.fPluginInitializationDone = true;
                            }
                            catch (Exception e3) {
                                DVTLogger.INSTANCE.logError((Throwable)e3);
                            }
                        });
                        DVTLogger.INSTANCE.logDebug("<< Ended DVT initialization.");
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
        });
    }

    private static void registerNewFileListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new NewResourceListener(), 1);
    }

    protected void setupIntrpDebug() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.getBreakpointManager().addBreakpointListener((IBreakpointsListener)IntrpBreakpointListener.getDefault());
    }

    public boolean isPluginInitializationDone() {
        return this.fPluginInitializationDone;
    }

    private void hideCDTIncludes() {
        try {
            if (!DVTSPreferencesManager.INSTANCE.isNewWorkspace()) {
                return;
            }
            CommonNavigator view = (CommonNavigator)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.navigator.ProjectExplorer");
            INavigatorActivationService activationService = view.getNavigatorContentService().getActivationService();
            activationService.deactivateExtensions(new String[]{"org.eclipse.cdt.ui.navigator.content"}, false);
            activationService.persistExtensionActivations();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void backwardCompatibility() {
        try {
            HashSet<IValueVariable> valVars = new HashSet<IValueVariable>();
            IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
            for (String varName : Arrays.asList("SPECMAN_PATH", "load_specman_tops", "load_specman_tests", "incdir", "ncvlog_incdir")) {
                IValueVariable valueVariable = varManager.getValueVariable(varName);
                if (valueVariable == null) continue;
                valVars.add(valueVariable);
            }
            varManager.removeVariables(valVars.toArray(new IValueVariable[0]));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            DVTHelp.stopPoolingHelp();
            DirtyEditorSaver.getInstance().stop();
            WorkspaceDiskSpaceChecker.getInstance().stop();
            DVTProblemsUiUpdaterRegistry.stopAll();
            NewSearchUI.removeQueryListener((IQueryListener)SearchViewQueryListener.getInstance());
            this.uninstallAutobuildListeners();
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)DVTBreakpointMarkerChangeListener.INSTANCE);
            EditorEmulationHelper.INSTANCE.uninstallListeners();
            DVTManageLargeFileEditors.INSTANCE.dispose();
            DVTAutoIndentDetectionManager.INSTANCE.dispose();
            if (this.fSelectionManager != null) {
                this.fSelectionManager.dispose();
            }
            MarkerSelectionManager.INSTANCE.stop();
            PreferenceUtils.INSTANCE.dispose();
            DebugPlugin debugPlugin = DebugPlugin.getDefault();
            debugPlugin.getBreakpointManager().removeBreakpointListener((IBreakpointsListener)IntrpBreakpointListener.getDefault());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        DVTLogger.INSTANCE.logDebug("<< Ended DVT Plugin.");
        super.stop(context);
    }

    public DVTSplash collect() {
        return this.fSplash;
    }

    public static DVTPlugin getDefault() {
        return fPlugin;
    }

    public String getVersion() {
        try {
            return (String)this.getBundle().getHeaders().get("Bundle-Version");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private void showSplash() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null) {
                return;
            }
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            Shell workbenchShell = activeWorkbenchWindow.getShell();
            if (workbenchShell == null || workbenchShell.isDisposed()) {
                return;
            }
            Display display = workbenchShell.getDisplay();
            if (display == null || display.isDisposed()) {
                return;
            }
            display.asyncExec(() -> {
                final Shell shell2 = new Shell(workbenchShell, 16392);
                shell2.setLayout((Layout)new FillLayout());
                Label image = new Label((Composite)shell2, 0);
                image.setImage(DVTImages.imageCache.getImage(DVTImages.DVT_SPLASH));
                shell2.pack();
                Rectangle parentBounds = workbenchShell.getBounds();
                shell2.setLocation(parentBounds.x + (parentBounds.width - shell2.getBounds().width) / 2, parentBounds.y + (parentBounds.height - shell2.getBounds().height) / 2);
                image.addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent e) {
                        this.close();
                    }

                    public void mouseDown(MouseEvent e) {
                        this.close();
                    }

                    public void mouseUp(MouseEvent e) {
                        this.close();
                    }

                    void close() {
                        if (!shell2.isDisposed()) {
                            shell2.close();
                        }
                    }
                });
                display.timerExec(2000, () -> {
                    if (!shell2.isDisposed()) {
                        shell2.close();
                    }
                });
                shell2.open();
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public void savePreferences() {
        try {
            InstanceScope instance = new InstanceScope();
            instance.getNode(PLUGIN_ID).flush();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IEclipsePreferences getPreferences() {
        InstanceScope instance = new InstanceScope();
        return instance.getNode(PLUGIN_ID);
    }

    public IEclipsePreferences getPreferences(String id) {
        InstanceScope instance = new InstanceScope();
        return instance.getNode(id);
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public boolean isShuttingDown() {
        return this.fIsSuttingDown;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = DVTPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = DVTPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return DVTPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    private void uninstallAutobuildListeners() {
        IPreferenceStore preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        if (preferenceStore == null) {
            return;
        }
        preferenceStore.removePropertyChangeListener((IPropertyChangeListener)FIncrementalBuildAutoChangeListener.INSTANCE);
        IEclipsePreferences eclipsePreferences = DVTPlugin.getDefault().getPreferences("org.eclipse.core.resources");
        if (eclipsePreferences == null) {
            return;
        }
        eclipsePreferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)FIncrementalBuildAutoChangeListener.INSTANCE);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)FIncrementalBuildAutoChangeListener.INSTANCE);
    }

    private void installAutobuildListeners() {
        IEclipsePreferences eclipsePreferences = DVTPlugin.getDefault().getPreferences("org.eclipse.core.resources");
        if (eclipsePreferences == null) {
            return;
        }
        eclipsePreferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)FIncrementalBuildAutoChangeListener.INSTANCE);
        IPreferenceStore preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        if (preferenceStore == null) {
            return;
        }
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)FIncrementalBuildAutoChangeListener.INSTANCE);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)FIncrementalBuildAutoChangeListener.INSTANCE);
    }
}

