/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.settings.DVTSConstants;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.AutobuildDisabledDialog;
import ro.amiq.dvt.ui.InvalidSettingsLocationDialog;

public class DVTSanityCheck {
    protected static void checkAutoBuildEnabled() {
        if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            return;
        }
        if (!DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.PERFORM_AUTOBUILD_DISABLED_CHECK")) {
            return;
        }
        AutobuildDisabledDialog.show();
    }

    protected static void checkCommonSettingsDir() {
        if (TestHelper.isTestMode() && !"true".equalsIgnoreCase(System.getenv("ENABLE_COMMON_SETTINGS_PATHS_CHECK"))) {
            return;
        }
        if (!DVTPlugin.getDefault().getPreferenceStore().getBoolean("common.settings.paths.check")) {
            return;
        }
        HashSet<String> validPaths = new HashSet<String>(2);
        HashSet<String> invalidPaths = new HashSet<String>(2);
        DVTSanityCheck.checkExistCommonSettingsPaths(validPaths, invalidPaths);
        if (invalidPaths.isEmpty()) {
            return;
        }
        InvalidSettingsLocationDialog.show(validPaths, invalidPaths);
    }

    private static void checkExistCommonSettingsPaths(Set<String> validPaths, Set<String> invalidPaths) {
        if (DVTSConstants.DVT_COMMON_SETTINGS == null) {
            return;
        }
        int i = 0;
        while (i < DVTSConstants.DVT_COMMON_SETTINGS.length) {
            File commonSettingsDir = new File(DVTSConstants.DVT_COMMON_SETTINGS[i]);
            if (commonSettingsDir.exists()) {
                validPaths.add("> " + commonSettingsDir.toString().trim());
            } else {
                invalidPaths.add("> " + commonSettingsDir.toString().trim());
            }
            ++i;
        }
    }
}

