/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import ro.amiq.dvt.IResourceSelectionChangeListener;
import ro.amiq.dvt.OpenLocalFileActionFix;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.guifilters.GUIFiltersHandler;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.refactoring.RefactoringConnectView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;

public class DVTSelectionManager {
    private HashMap<IWorkbenchWindow, Set<IResourceSelectionChangeListener>> fResourceSelectionChangeListeners = new HashMap();
    private HashMap<IWorkbenchWindow, IResource> fLastSelectedResourceMap = new HashMap();
    private HashMap<IWorkbenchWindow, IWorkbenchPart> fLastSelectedPartMap = new HashMap();
    private HashSet<IWorkbenchWindow> fResourceSelectionChangeRegistered = new HashSet();
    private HashMap<IWorkbenchWindow, ISelection> fLastSelection = new HashMap();

    public void dispose() {
        this.fLastSelectedResourceMap.clear();
        this.fLastSelectedResourceMap = null;
        this.fLastSelectedPartMap.clear();
        this.fLastSelectedPartMap = null;
        this.fResourceSelectionChangeRegistered.clear();
        this.fResourceSelectionChangeRegistered = null;
        this.fResourceSelectionChangeListeners.clear();
        this.fResourceSelectionChangeListeners = null;
        this.fLastSelection.clear();
        this.fLastSelection = null;
    }

    public void pluginStarted() {
        this.registerResourceListener();
        this.setInitialSelectedProject();
        if (this.getLastSelectedProject() != null) {
            BasicNewResourceWizard.selectAndReveal((IResource)this.getLastSelectedProject(), (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
    }

    private void registerResourceListener() {
        Assert.isTrue((Display.getCurrent() != null ? 1 : 0) != 0, (String)"Trying to register a selection listener on non-UI thread");
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null) {
                return;
            }
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            if (workbenchWindow == null) {
                return;
            }
            if (this.fResourceSelectionChangeRegistered.contains(workbenchWindow)) {
                return;
            }
            IWorkbenchPage activePage = workbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            SelectionListener selectionListener = new SelectionListener();
            activePage.addSelectionListener((ISelectionListener)selectionListener);
            IPartListener partListener = this.getPartListener(workbenchWindow);
            activePage.addPartListener(partListener);
            WindowListener windowListener = new WindowListener(selectionListener);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)windowListener);
            this.fResourceSelectionChangeRegistered.add(workbenchWindow);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private IPartListener getPartListener(final IWorkbenchWindow workbenchWindow) {
        return new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                DVTSelectionManager.this.removeConnectDiagram(part);
                DVTSelectionManager.this.removeLastSelectedPart(workbenchWindow, part);
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        };
    }

    private void removeConnectDiagram(IWorkbenchPart part) {
        if (!(part instanceof DDiagramEditor)) {
            return;
        }
        RefactoringConnectView view = (RefactoringConnectView)ViewsUtils.getViewById("ro.amiq.dvt.ui.views.RefactoringConnectView", false);
        if (view == null) {
            return;
        }
        DDiagramEditor connectDiagram = view.getEditor();
        if (connectDiagram == null || connectDiagram != part) {
            return;
        }
        view.setEditor(null);
    }

    private void removeLastSelectedPart(IWorkbenchWindow workbenchWindow, IWorkbenchPart part) {
        if (this.fLastSelectedPartMap.get(workbenchWindow) != part) {
            return;
        }
        this.fLastSelectedPartMap.remove(workbenchWindow);
    }

    private void notifySelectionListenersForInitialProject(IResource resource) {
        this.setLastSelectedResource(resource);
        Set<IResourceSelectionChangeListener> listeners = this.fResourceSelectionChangeListeners.get(ro.amiq.dvt.ui.Utils.getActiveWorkbenchWindow());
        if (listeners == null) {
            return;
        }
        for (IResourceSelectionChangeListener listener : listeners) {
            listener.resourceSelectionChanged(resource);
        }
    }

    private void setInitialSelectedProject() {
        try {
            LinkedList<IProject> availableProjects = this.getAvailableProjects();
            if (availableProjects == null || availableProjects.isEmpty()) {
                this.notifySelectionListenersForInitialProject(null);
                return;
            }
            if (availableProjects.size() == 1) {
                this.notifySelectionListenersForInitialProject((IResource)availableProjects.getFirst());
                return;
            }
            IFile file = this.getSelectedFile();
            if (file != null) {
                this.notifySelectionListenersForInitialProject((IResource)file);
                return;
            }
            IResource selectedResource = this.getSelectedResourceFromNavigator();
            if (selectedResource != null) {
                this.notifySelectionListenersForInitialProject(selectedResource);
                return;
            }
            this.notifySelectionListenersForInitialProject((IResource)availableProjects.getFirst());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private LinkedList<IProject> getAvailableProjects() {
        LinkedList<IProject> availableProjects = new LinkedList<IProject>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return availableProjects;
        }
        IWorkspaceRoot root = workspace.getRoot();
        if (root == null) {
            return availableProjects;
        }
        IProject[] allProjects = root.getProjects();
        if (allProjects.length == 0) {
            return availableProjects;
        }
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (iProject.isAccessible() && Utils.hasDvtNature(iProject)) {
                availableProjects.add(iProject);
            }
            ++n2;
        }
        return availableProjects;
    }

    private IFile getSelectedFile() {
        IEditorPart editor = DVTFileUtils.getInstance().getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        return file;
    }

    private IResource getSelectedResourceFromNavigator() {
        Object selected;
        block19: {
            ISelection selection;
            block18: {
                block17: {
                    ISelectionProvider selectionProvider;
                    block16: {
                        IWorkbenchPartSite site;
                        block15: {
                            IViewPart view;
                            block14: {
                                IWorkbenchPage activePage;
                                block13: {
                                    IWorkbenchWindow activeWorkbenchWindow;
                                    block12: {
                                        IWorkbench workbench;
                                        block11: {
                                            try {
                                                workbench = PlatformUI.getWorkbench();
                                                if (workbench != null) break block11;
                                                return null;
                                            }
                                            catch (Exception e) {
                                                DVTLogger.INSTANCE.logError((Throwable)e);
                                                return null;
                                            }
                                        }
                                        activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                                        if (activeWorkbenchWindow != null) break block12;
                                        return null;
                                    }
                                    activePage = activeWorkbenchWindow.getActivePage();
                                    if (activePage != null) break block13;
                                    return null;
                                }
                                view = activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
                                if (view != null) break block14;
                                return null;
                            }
                            site = view.getSite();
                            if (site != null) break block15;
                            return null;
                        }
                        selectionProvider = site.getSelectionProvider();
                        if (selectionProvider != null) break block16;
                        return null;
                    }
                    selection = selectionProvider.getSelection();
                    if (selection instanceof IStructuredSelection) break block17;
                    return null;
                }
                if (((IStructuredSelection)selection).size() == 1) break block18;
                return null;
            }
            selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof IResource) break block19;
            return null;
        }
        return (IResource)selected;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IResource getResource(IWorkbenchPartSite site) {
        try {
            if (site == null) {
                return null;
            }
            IWorkbenchPage page = site.getPage();
            if (page == null) {
                return null;
            }
            ISelection selection = page.getSelection();
            if (selection == null) {
                return null;
            }
            if (selection instanceof IStructuredSelection) {
                if (((IStructuredSelection)selection).size() != 1) {
                    return null;
                }
                Object selected = ((IStructuredSelection)selection).getFirstElement();
                if (selected == null) {
                    return null;
                }
                if (selected instanceof IResource) return (IResource)selected;
                return null;
            }
            if (!(selection instanceof TextSelection)) return null;
            IEditorPart editor = page.getActiveEditor();
            if (editor == null) {
                return null;
            }
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput != null) return (IFile)editorInput.getAdapter(IFile.class);
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private void notifyResourceSelectionChangeListeners(IWorkbenchPart part, IResource resource) {
        IWorkbenchWindow activeWindow = part == null ? ro.amiq.dvt.ui.Utils.getActiveWorkbenchWindow() : part.getSite().getWorkbenchWindow();
        IResource prevResource = this.fLastSelectedResourceMap.get(activeWindow);
        IWorkbenchPart prevWorkbenchPart = this.fLastSelectedPartMap.get(activeWindow);
        if (resource == prevResource && part == prevWorkbenchPart) {
            return;
        }
        if (prevResource != null) {
            IProject prevProject = prevResource.getProject();
            IProject nextProject = null;
            if (resource != null) {
                nextProject = resource.getProject();
            }
            if (prevProject != nextProject) {
                boolean filtering = GUIFiltersHandler.isFilteringEnabled();
                DVTViewManager.loadGuiFilters(nextProject, filtering);
            }
        }
        this.fLastSelectedResourceMap.put(activeWindow, resource);
        this.fLastSelectedPartMap.put(activeWindow, part);
        Set<IResourceSelectionChangeListener> listeners = this.fResourceSelectionChangeListeners.get(activeWindow);
        if (listeners == null) {
            return;
        }
        for (IResourceSelectionChangeListener listener : listeners) {
            listener.resourceSelectionChanged(resource);
        }
    }

    public void resetLastSelectedResource(IWorkbenchWindow window) {
        this.fLastSelectedResourceMap.put(window, null);
        this.fLastSelectedPartMap.put(window, null);
    }

    public void addResourceSelectionChangeListener(IWorkbenchWindow activeWindow, IResourceSelectionChangeListener listener) {
        Set<IResourceSelectionChangeListener> listeners = this.fResourceSelectionChangeListeners.get(activeWindow);
        if (listeners == null) {
            listeners = new HashSet<IResourceSelectionChangeListener>();
            this.fResourceSelectionChangeListeners.put(activeWindow, listeners);
        }
        listeners.add(listener);
    }

    public void addResourceSelectionChangeListener(IResourceSelectionChangeListener listener) {
        this.addResourceSelectionChangeListener(ro.amiq.dvt.ui.Utils.getActiveWorkbenchWindow(), listener);
    }

    public void removeResourceSelectionChangeListener(IWorkbenchWindow activeWindow, IResourceSelectionChangeListener listener) {
        if (this.fResourceSelectionChangeListeners == null || activeWindow == null) {
            return;
        }
        Set<IResourceSelectionChangeListener> listeners = this.fResourceSelectionChangeListeners.get(activeWindow);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public ISelection getLastSelection() {
        return this.fLastSelection.get(ro.amiq.dvt.ui.Utils.getActiveWorkbenchWindow());
    }

    public IResource getLastSelectedResource() {
        return this.fLastSelectedResourceMap.get(ro.amiq.dvt.ui.Utils.getActiveWorkbenchWindow());
    }

    public void setLastSelectedResource(IWorkbenchWindow activeWorkbenchWindow, IResource resource) {
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            this.notifyResourceSelectionChangeListeners(null, resource);
            return;
        }
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart == null) {
            this.notifyResourceSelectionChangeListeners(null, resource);
            return;
        }
        this.notifyResourceSelectionChangeListeners(activePart, resource);
    }

    public void setLastSelectedResource(IResource resource) {
        this.setLastSelectedResource(ro.amiq.dvt.ui.Utils.getActiveWorkbenchWindow(), resource);
    }

    public IProject getLastSelectedProject() {
        IWorkbenchWindow activeWindow = ro.amiq.dvt.ui.Utils.getActiveWorkbenchWindow();
        IResource resource = this.fLastSelectedResourceMap.get(activeWindow);
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        return project;
    }

    public void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        try {
            if (window != null && window.getActivePage() != null) {
                this.notifyResourceSelectionChangeListeners(window.getActivePage().getActivePart(), resource);
            } else {
                this.notifyResourceSelectionChangeListeners(null, resource);
            }
            BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)window);
            IWorkbenchPage activePage = ro.amiq.dvt.ui.Utils.getActivePage();
            if (activePage == null) {
                return;
            }
            IViewPart projectExplorer = activePage.showView("org.eclipse.ui.navigator.ProjectExplorer");
            if (projectExplorer == null) {
                return;
            }
            IWorkbenchPartSite projectExplorerSite = projectExplorer.getSite();
            if (projectExplorerSite == null) {
                return;
            }
            ISelectionProvider projectExplorerSelectionProvider = projectExplorerSite.getSelectionProvider();
            if (projectExplorerSelectionProvider == null) {
                return;
            }
            projectExplorerSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)resource));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private class SelectionListener
    implements ISelectionListener {
        private SelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part == null) {
                return;
            }
            DVTSelectionManager.this.fLastSelection.put(part.getSite().getWorkbenchWindow(), selection);
            IResource resource = (IResource)part.getAdapter(IResource.class);
            if (resource == null && part instanceof ProjectExplorer) {
                resource = DVTSelectionManager.this.getResource(part.getSite());
            }
            if (resource == null && part instanceof TextEditor && ((TextEditor)part).getEditorInput() != null) {
                resource = (IResource)((TextEditor)part).getEditorInput().getAdapter(IResource.class);
            }
            if (resource == null) {
                return;
            }
            OpenLocalFileActionFix.setOpenLocalFilePath(resource);
            DVTSelectionManager.this.notifyResourceSelectionChangeListeners(part, resource);
        }
    }

    private class WindowListener
    implements IWindowListener {
        private ISelectionListener fSelectionListener;
        private Map<IWorkbenchWindow, IPartListener> fPartListenersMap;

        public WindowListener(ISelectionListener selectionListener) {
            this.fSelectionListener = selectionListener;
            this.fPartListenersMap = new LinkedHashMap<IWorkbenchWindow, IPartListener>();
        }

        public void windowOpened(final IWorkbenchWindow window) {
            IWorkbenchPage activePage = window.getActivePage();
            if (activePage == null) {
                return;
            }
            if (this.fSelectionListener != null) {
                activePage.addSelectionListener(this.fSelectionListener);
            }
            DVTSelectionManager.this.fResourceSelectionChangeRegistered.add(window);
            DVTSelectionManager.this.setInitialSelectedProject();
            if (DVTSelectionManager.this.getLastSelectedProject() != null) {
                BasicNewResourceWizard.selectAndReveal((IResource)DVTSelectionManager.this.getLastSelectedProject(), (IWorkbenchWindow)window);
            }
            IPartListener partListener = new IPartListener(){

                public void partOpened(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                    DVTSelectionManager.this.removeLastSelectedPart(window, part);
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partActivated(IWorkbenchPart part) {
                }
            };
            this.fPartListenersMap.put(window, partListener);
            activePage.addPartListener(partListener);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            IPartListener partListener;
            IWorkbenchPage activePage = window.getActivePage();
            if (activePage == null) {
                return;
            }
            if (this.fSelectionListener != null) {
                activePage.removeSelectionListener(this.fSelectionListener);
            }
            if ((partListener = this.fPartListenersMap.remove(window)) == null) {
                return;
            }
            activePage.removePartListener(partListener);
        }

        public void windowActivated(IWorkbenchWindow window) {
        }
    }
}

