/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.DVTSplashDialog;
import ro.amiq.dvt.DVTSplashInfo;
import ro.amiq.dvt.DVTSplashNotification;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public enum DVTSplashControl implements BiConsumer<DVTSplashInfo.State, String>
{
    INSTANCE;

    private final Map<DVTSplashInfo.State, Color> colors = new EnumMap<DVTSplashInfo.State, Color>(DVTSplashInfo.State.class);
    private DVTSplashInfo.State currentState;
    private Canvas canvas;

    public void init() {
        Composite trimToolbar = DVTUiUtils.getTrimToolbarParent((Composite)DVTUiUtils.getActiveWorkbenchShell());
        if (trimToolbar == null) {
            DVTLogger.INSTANCE.logError("License status bar not initialized. Trim toolbar could not be found.");
            return;
        }
        Composite composite = new Composite(trimToolbar, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setToolTipText("DVT Version");
        label.setText(DVTPlugin.getDefault().getBundle().getVersion().toString());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)label);
        this.canvas = new Canvas(composite, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(24, 0);
            }
        };
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.canvas);
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DVTSplashDialog.show();
            }
        });
        this.canvas.addPaintListener(this::paint);
        this.colors.put(DVTSplashInfo.State.LICENSE_NOT_SET, new Color((Device)trimToolbar.getDisplay(), 186, 104, 200));
        this.colors.put(DVTSplashInfo.State.ERROR, new Color((Device)trimToolbar.getDisplay(), 229, 115, 115));
        this.colors.put(DVTSplashInfo.State.QUEUED, new Color((Device)trimToolbar.getDisplay(), 100, 181, 246));
        this.colors.put(DVTSplashInfo.State.TIMEOUT, new Color((Device)trimToolbar.getDisplay(), 255, 213, 79));
        this.colors.put(DVTSplashInfo.State.IDLE, new Color((Device)trimToolbar.getDisplay(), 161, 136, 127));
        this.colors.put(DVTSplashInfo.State.ACQUIRED, new Color((Device)trimToolbar.getDisplay(), 129, 199, 132));
        this.colors.put(DVTSplashInfo.State.INITIAL, new Color((Device)trimToolbar.getDisplay(), 192, 192, 192));
        DVTSplashInfo.INSTANCE.addGlobalStateListener(this);
        trimToolbar.addDisposeListener(e -> this.dispose());
        trimToolbar.layout();
    }

    @Override
    public void accept(DVTSplashInfo.State newState, String newInfo) {
        if (newState != this.currentState) {
            this.showNotification(newState);
        }
        this.currentState = newState;
        this.updateLicenseStatus(newState, newInfo);
    }

    private void showNotification(DVTSplashInfo.State newState) {
        if (newState == DVTSplashInfo.State.LICENSE_NOT_SET) {
            DVTSplashNotification.show("dialog_message_error_image", "DVT License Not Set", "No valid license source found.\nOne of the DVT_LICENSE_FILE, DVTLMD_LICENSE_FILE, LM_LICENSE_FILE\nlicense variables must point to a valid license source.", true);
        } else if (newState == DVTSplashInfo.State.ERROR) {
            DVTSplashNotification.show("dialog_message_error_image", "DVT License Error", "There was an error checking-out the license.", true);
        } else if (newState == DVTSplashInfo.State.QUEUED) {
            DVTSplashNotification.show("dialog_messasge_warning_image", "DVT License Queued", "No licenses available,\nwaiting in queue for a license.", false);
        } else if (newState == DVTSplashInfo.State.TIMEOUT) {
            DVTSplashNotification.show("dialog_messasge_warning_image", "DVT License Connection Timeout", "The connection with the license server was lost,\nthe license will be checked-in soon.", true);
        } else if (newState == DVTSplashInfo.State.ACQUIRED) {
            DVTSplashNotification.closeLast();
        }
    }

    private void updateLicenseStatus(DVTSplashInfo.State newState, String newInfo) {
        Display.getDefault().asyncExec(() -> {
            if (this.canvas == null || this.canvas.isDisposed()) {
                return;
            }
            this.canvas.setToolTipText(newInfo);
            this.canvas.redraw();
        });
    }

    private void paint(PaintEvent e) {
        DVTSplashInfo.State state = this.currentState;
        if (e.gc.isDisposed()) {
            return;
        }
        if (!(e.getSource() instanceof Canvas)) {
            return;
        }
        e.gc.setAdvanced(true);
        e.gc.setAntialias(1);
        e.gc.setTextAntialias(1);
        Point size = ((Canvas)e.getSource()).getSize();
        int w = size.x;
        int h = size.y;
        int m = Math.min(w, h);
        int l = m - m % 8;
        int l1v6 = (int)((double)l / 1.6);
        int lp8 = l / 6;
        int lp4 = l / 4;
        int lp2 = l / 2;
        int x0 = (w - l) / 2;
        int x1 = (w + l) / 2;
        int xc = w / 2;
        int y0 = (h - l) / 2;
        int y1 = (h + l) / 2;
        int yc = h / 2;
        e.gc.setBackground(this.colors.get((Object)state));
        e.gc.fillRoundRectangle(x0, y0, l, l, l1v6, l1v6);
        e.gc.setAlpha(192);
        e.gc.setLineWidth(1);
        e.gc.setForeground(Display.getDefault().getSystemColor(2));
        e.gc.drawRoundRectangle(x0, y0, l, l, l1v6, l1v6);
        if (state == DVTSplashInfo.State.INITIAL || state == DVTSplashInfo.State.IDLE) {
            e.gc.drawLine(x0 + lp8, yc, x1 - lp8, yc);
        } else if (state == DVTSplashInfo.State.ERROR || state == DVTSplashInfo.State.LICENSE_NOT_SET) {
            e.gc.drawLine(x0 + lp4, y0 + lp4, x1 - lp4, y1 - lp4);
            e.gc.drawLine(x1 - lp4, y0 + lp4, x0 + lp4, y1 - lp4);
        } else if (state == DVTSplashInfo.State.QUEUED) {
            e.gc.drawOval(xc - lp4, yc - lp4, lp2, lp2);
        } else if (state == DVTSplashInfo.State.TIMEOUT) {
            e.gc.drawLine(x0 + lp4, y0 + lp4, x1 - lp4, y1 - lp4);
        }
    }

    private void dispose() {
        DVTSplashInfo.INSTANCE.removeGlobalStateListener();
        for (Color color : this.colors.values()) {
            if (color == null || color.isDisposed()) continue;
            color.dispose();
        }
        this.colors.clear();
    }
}

