/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.function.Consumer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.flclient.DFLI;

public class DVTSplashDialog
extends Dialog
implements Consumer<String> {
    private static final String TITLE = "DVT License Log";
    private static boolean logTrace = Boolean.parseBoolean(System.getenv("DVT_LICENSE_LOG_TRACE"));
    private Text text;

    private DVTSplashDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2160);
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.text = new Text(composite, 2826);
        GridDataFactory.fillDefaults().grab(true, true).hint(960, 600).applyTo((Control)this.text);
        this.text.setFont(JFaceResources.getTextFont());
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == 'T') {
                    logTrace = !logTrace;
                    DFLI.I.k(logTrace);
                    DVTSplashDialog.this.setTitle();
                }
            }
        });
        this.text.addDisposeListener(e -> DFLI.I.n((Consumer)this));
        DFLI.I.m((Consumer)this);
        this.text.setText(DFLI.I.l());
        this.setTitle();
        return composite;
    }

    private void setTitle() {
        this.getShell().setText(TITLE + (logTrace ? " - TRACE" : ""));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    @Override
    public void accept(String s) {
        Display.getDefault().asyncExec(() -> this.text.append(s));
    }

    public static void show() {
        Display.getDefault().asyncExec(() -> {
            int n = new DVTSplashDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).open();
        });
    }
}

