/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.flclient.DFLI;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum DVTSplashInfo {
    INSTANCE;

    private final TreeMap<String, String> featureStates = new TreeMap();
    private final AtomicReference<BiConsumer<State, String>> globalStateListener = new AtomicReference();
    private final AtomicReference<Consumer<State>> coreStateListener = new AtomicReference();

    private DVTSplashInfo() {
        this.featureStates.putAll(DFLI.I.o());
        DFLI.I.p(i -> {
            this.featureStates.put(((String[])i)[0], ((String[])i)[2]);
            this.update();
        });
    }

    public void addGlobalStateListener(BiConsumer<State, String> listener) {
        this.globalStateListener.set(listener);
        this.update();
    }

    public void removeGlobalStateListener() {
        this.globalStateListener.set(null);
    }

    public void addCoreStateListener(Consumer<State> listener) {
        this.coreStateListener.set(listener);
        this.update();
    }

    public void removeCoreStateListener() {
        this.coreStateListener.set(null);
    }

    private String computeInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("DVT Checked-out License Status").append("\n\n");
        if (!DFLI.I.v()) {
            sb.append("    ").append("License not set.").append('\n');
        } else if (!this.featureStates.values().stream().anyMatch(string -> !string.equalsIgnoreCase("INITIAL"))) {
            sb.append("    ").append("No features checked-out.").append('\n');
        } else {
            this.featureStates.entrySet().stream().filter(entry -> !((String)entry.getValue()).equalsIgnoreCase("INITIAL")).forEach(entry -> {
                StringBuilder stringBuilder2 = sb.append("    ").append((String)entry.getKey()).append(" : ").append((String)entry.getValue()).append('\n');
            });
        }
        return sb.toString();
    }

    private State computeGlobalState() {
        if (!DFLI.I.v()) {
            return State.LICENSE_NOT_SET;
        }
        int index = State.INITIAL.ordinal();
        for (String state : this.featureStates.values()) {
            index = Math.min(index, State.valueOf(state).ordinal());
        }
        return State.values()[index];
    }

    private State computeCoreState() {
        if (!DFLI.I.v()) {
            return State.LICENSE_NOT_SET;
        }
        for (Map.Entry<String, String> entry : this.featureStates.entrySet()) {
            if (!entry.getKey().equals(DVTPlugin.getDefault().collect().dec("F636F7265"))) continue;
            return State.valueOf(entry.getValue());
        }
        return State.INITIAL;
    }

    private void update() {
        if (this.globalStateListener.get() != null) {
            try {
                this.globalStateListener.get().accept(this.computeGlobalState(), this.computeInfo());
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (this.coreStateListener.get() != null) {
            try {
                this.coreStateListener.get().accept(this.computeCoreState());
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public static enum State {
        LICENSE_NOT_SET,
        ERROR,
        QUEUED,
        TIMEOUT,
        IDLE,
        ACQUIRED,
        INITIAL;

    }
}

