/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTJobsUtils;

public enum DVTSplashMLT {
    INSTANCE;

    private static final boolean TEST_MODE = false;
    public static final long MINIMUM_LICENSE_TIME = 60000L;
    public static final long BATCH_MINIMUM_LICENSE_TIME = 3000L;
    private Set<String> checkedInFeatures = Collections.synchronizedSet(new HashSet());
    private Map<String, Long> fLastFeatureCheckoutTime = Collections.synchronizedMap(new HashMap());

    private DVTSplashMLT() {
        new Thread(() -> {
            while (!DVTPlugin.getDefault().isShuttingDown()) {
                try {
                    if (!this.checkedInFeatures.isEmpty()) {
                        for (Map.Entry<String, Long> entry : this.fLastFeatureCheckoutTime.entrySet()) {
                            long remainingTime;
                            if (!this.checkedInFeatures.contains(entry.getKey()) || (remainingTime = this.getRemainingTime(entry.getValue())) > 0L) continue;
                            this.checkedInFeatures.remove(entry.getKey());
                            DVTPlugin.getDefault().collect().i(entry.getKey());
                        }
                    }
                    DVTJobsUtils.delay(1000L);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }).start();
    }

    public boolean cc(boolean wait, String ... ss) {
        boolean result = DVTPlugin.getDefault().collect().cc(ss);
        if (result && wait) {
            this.addLicenseCheckoutTime(ss);
        }
        return result;
    }

    public boolean cc(BooleanSupplier isCanceled, boolean wait, String ... s) {
        boolean result = DVTPlugin.getDefault().collect().cc(isCanceled, s);
        if (result && wait) {
            this.addLicenseCheckoutTime(s);
        }
        return result;
    }

    public boolean cc(String ... s) {
        return DVTPlugin.getDefault().collect().cc(0, s);
    }

    protected void addLicenseCheckoutTime(String ... ss) {
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.checkedInFeatures.remove(s);
            this.fLastFeatureCheckoutTime.put(s, System.currentTimeMillis());
            ++n2;
        }
    }

    public void i(boolean wait, String s) {
        if (wait) {
            this.checkedInFeatures.add(s);
        } else if (!this.checkedInFeatures.contains(s)) {
            DVTPlugin.getDefault().collect().i(s);
        }
    }

    private long getRemainingTime(Long checkoutTime) {
        return 60000L - (System.currentTimeMillis() - checkoutTime);
    }
}

